/*
 * lib/mesg.c
 * @(#) library functions for sending and receiving messages
 * (c) 1995 by Mihai Budiu
 */

#define __LIB__ 1
#include "../include/message.h"
#include "../include/unistd.h"
#include "../include/pid.h"
#include "../include/error.h"
#include "../include/operation.h"  /* for SIGNAL */

int send(LOCAL_PID destination, operation_t op, struct message * msg)
     /* local variant of send */
{
  msg->DESTINATION.local_pid = destination;
#if 0
  msg->DESTINATION.machine = LOCAL;
  msg->DESTINATION.thread = 0;
#endif
  msg->OPERATION = op;
  return sys_call(SEND, msg);
}

int send_reply(LOCAL_PID destination, msg_id_t id, operation_t op, 
	       err_t error, struct message * msg)
     /* local variant of reply; reply to the message with id */
{
  msg->DESTINATION.local_pid = destination;
  msg->MSGID= id;
#if 0
  msg->DESTINATION.machine = LOCAL;
  msg->DESTINATION.thread = 0;
#endif
  msg->OPERATION = REPLY_TO(op);
  msg->ERROR = error;
  return sys_call(SEND, msg);
}

int receive(struct message * msg)
     /* receive from anybody */
{
  msg->SOURCE.local_pid = ANY_PID;
  return sys_call(RECEIVE, msg);
}

int send_receive(LOCAL_PID destination, operation_t op, struct message * msg)
     /* send-rec locally */
{
  msg->DESTINATION.local_pid = destination;
#if 0
  msg->DESTINATION.machine = LOCAL;
  msg->DESTINATION.thread = 0;
#endif
  msg->OPERATION = op;
  return sys_call(SEND_REC, msg);
}

int signal(proc_id process, signal_t signal)
     /* send a message to the system task asking for a signal */
{
  struct message m;
  int err;

  m.SIGNAL_ME = signal;
  * (proc_id *) m.INFO = process;
  err = send_receive(SYS_PID, SIGNAL, &m);
  if (err != E_OK) return err;
  return m.ERROR;
}

#if 0
int send_remote()
     /* not implemented */
{
  return E_ILL;
}

int receive_remote()
     /* not implemented */
{
  return E_ILL;
}

int send_receive_remote()
     /* not implemented */
{
  return E_ILL;
}
#endif
