/*
 * keyboard/queue.h
 * @(#) queues handling
 * (c) 1995 by Mihai Budiu
 */

#ifndef _QUEUE_H
#define _QUEUE_H

#ifndef YES
#define YES 1
#endif
#ifndef NO
#define NO 0
#endif

#define QUEUE(NAME, TYPE, SIZE) \
 \
struct NAME \
{ \
  int first; \
  int last;  \
  int empty; \
  int size;  \
  TYPE contents[SIZE]; \
} NAME; \
 \
void init_queue(struct NAME * q) \
{ \
  q->size = SIZE; \
  q->first = q->last = 0; \
  q->empty = YES; \
} \
 \
void put_queue(TYPE o, struct NAME * q, int circular) \
{ \
  if (circular || q->last != q->first || q->empty)   \
    q->contents[q->last++] = o; \
  q->last %= q->size; \
  q->empty = NO; \
} \
 \
TYPE get_queue(struct NAME * q) \
{ \
  TYPE o; \
  if (q->empty) return (TYPE) 0; \
  o = q->contents[q->first++]; \
  q->first %= q->size; \
  if (q->first == q->last) q->empty = YES; \
  return o; \
} \
 \
int empty(struct NAME * q) \
{ \
  return q->empty; \
}
#endif
