/*
 * keyboard/keycodes.h
 * @(#) macros for key code translation
 * (c) 1995 by Mihai Budiu
 */

#ifndef _KEYCODES_H  /* could do without */
#define _KEYCODES_H

/* keyboard leds position */
#define LED_CAPS  2
#define LED_NUM   1
#define LED_SCR   0

/* some codes for uncommon keys */
#define ESC   033
#define CR    015
#define CTRL  0200  /* should be different from any key */
#define SH    0201
#define RSH   0202
#define ALT   0203
#define CAPS  0204
#define F1    0241
#define F2    (F1 + 1)
#define F3    (F1 + 2)
#define F4    (F1 + 3)
#define F5    (F1 + 4)
#define F6    (F1 + 5)
#define F7    (F1 + 6)
#define F8    (F1 + 7)
#define F9    (F1 + 8)
#define F10   (F1 + 9)
#define NUM   205
#define SCR   206
#define HOME  0267
#define UP    0270
#define PGUP  0271
#define KPM   0211
#define LEFT  0264
#define RIGT  0266
#define KPP   0214
#define END   0261
#define DOWN  0262
#define PGDN  0263
#define INS   0
#define DEL   0177
#define SF1   0221
#define SF2   (SF1 + 1)
#define SF3   (SF1 + 2)
#define SF4   (SF1 + 3)
#define SF5   (SF1 + 4)
#define SF6   (SF1 + 5)
#define SF7   (SF1 + 6)
#define SF8   (SF1 + 7)
#define SF9   (SF1 + 8)
#define SF10  (SF1 + 9)

#define TOP_ROW 14    /* last key on the numbers' (top) row */
#define PAD 70        /* first code on num. pad */
#define CTRL_AT 0220  /* code for CTRL-@ */

PRIVATE unsigned char mapnosh[] = {  
         /* key translation table for unshifted codes */
  0,   ESC, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', '\b',
  '\t','q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', CR,
  CTRL,'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '\'','`',
  SH,  '\\','z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/', RSH,
  '*', ALT, ' ', CAPS, F1,  F2,  F3,  F4,  F5,  F6,  F7,  F8,  F9, F10,
  NUM, SCR,HOME, UP ,PGUP, KPM,LEFT,   0,RIGT, KPP, END,DOWN,PGDN, INS, DEL
};

PRIVATE unsigned char mapsh[] = {  /* key translation for shifted code */
  0,   ESC, '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '\b',
  '\t','Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', CR,
  CTRL,'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', ':','\"', '~',
  SH,  '|', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '<', '>', '?', RSH,
  '*', ALT, ' ', CAPS, SF1, SF2, SF3, SF4, SF5, SF6, SF7, SF8, SF9, SF10,
  NUM, SCR, '7', '8', '9', '-', '4', '5', '6', '+', '1', '2', '3', '0', '.'
};

#endif
