/* 
 * trap.c
 * @(#) trap handling
 * (c) 1995 by Mihai Budiu
 */

/*
   Build some initial trap handlers that just panic
*/

#include "../include/globals.h"
#include "../include/asm.h"
#include "./desc.h"
#include "../include/config.h"
#include "../include/error.h"
#include "../include/segment.h"

#define DEBUG_LOCAL 0
extern int printk(const char *, ...);

PRIVATE unsigned long 
  trap_error,  /* save here trap error code */
  trap_eip,    /* save here trap eip */
  trap_flags,  /* eflags */
  trap_cs,     /* cs */
  trap_esp,    /* etc */
  trap_ss;

PRIVATE char *trap_txt[17] = {
  "Division error",
  "Debug",
  "*UNKNOWN*",
  "INT 3",
  "Overflow",
  "Bounds",
  "Invalid OpCode",
  "Extension processor not present",
  "Double Fault",
  "Extension processor out of segment",
  "Invalid TSS",
  "Segment not present",
  "Stack fault",
  "General protection",
  "Page fault",
  "*UNKNOWN*",
  "Extension processor error"
};

#define TRAP_ROUTINE(t) trap_ ## t

#define _STR(x) #x
#define STR(x) _STR(x)

/* trap routine woth error code */
#define BUILD_ERR_TRAP(tp) \
void TRAP_ROUTINE(tp) (void); \
__asm__( \
"\n.align 4\n" \
"_trap_" #tp ":\n\t" \
	"pushl %ebx\n\t" \
	"push %ds\n\t" \
	"movl $" STR(KERNEL_DS) ", %ebx\n\t" \
	"movw %bx, %ds\n\t" \
	"movl 8(%esp), %ebx\n\t" \
	"movl %ebx, _trap_error\n\t" \
	"movl 12(%esp), %ebx\n\t" \
	"movl %ebx, _trap_eip\n\t" \
	"movl 16(%esp), %ebx\n\t" \
	"movl %ebx, _trap_cs\n\t" \
	"movl 20(%esp), %ebx\n\t" \
	"movl %ebx, _trap_flags\n\t" \
	"movl 24(%esp), %ebx\n\t" \
	"movl %ebx, _trap_esp\n\t" \
	"movl 28(%esp), %ebx\n\t" \
	"movl %ebx, _trap_ss\n\t" \
	"pop %ds\n\t" \
	"popl %ebx\n\t" \
	"addl $4, %esp\n\t" \
	SAVE_REGS \
	"movl $" STR(KERNEL_DS) ", %eax\n\t" \
	"movw %ax, %ds\n\t" \
	"movw %ax, %es\n\t" \
	"pushl $" #tp " \n\t" \
	"call _trap_err\n\t"  \
	"addl $4, %esp\n\t" \
	RESTORE_REGS \
	"iret\n" \
)

#define BUILD_TRAP(tp) \
void TRAP_ROUTINE(tp) (void); \
__asm__( \
"\n.align 4\n" \
"_trap_" #tp ":\n\t" \
	"pushl %ebx\n\t" \
	"push %ds\n\t" \
	"movl $" STR(KERNEL_DS) ", %ebx\n\t" \
	"movw %bx, %ds\n\t" \
	"movl 8(%esp), %ebx\n\t" \
	"movl %ebx, _trap_eip\n\t" \
	"movl 12(%esp), %ebx\n\t" \
	"movl %ebx, _trap_cs\n\t" \
	"movl 16(%esp), %ebx\n\t" \
	"movl %ebx, _trap_flags\n\t" \
	"movl 20(%esp), %ebx\n\t" \
	"movl %ebx, _trap_esp\n\t" \
	"movl 24(%esp), %ebx\n\t" \
	"movl %ebx, _trap_ss\n\t" \
	"pop %ds\n\t" \
	"popl %ebx\n\t" \
	SAVE_REGS \
	"movl $" STR(KERNEL_DS) ", %eax\n\t" \
	"movw %ax, %ds \n\t" \
	"pushl $" #tp " \n\t" \
	"call _trap\n\t"  \
	"addl $4, %esp\n\t" \
	RESTORE_REGS \
	"iret\n" \
)

/* generate the trap handling procedures */
BUILD_TRAP(0);
BUILD_TRAP(1);
BUILD_TRAP(2);
BUILD_TRAP(3);
BUILD_TRAP(4);
BUILD_TRAP(5);
BUILD_TRAP(6);
BUILD_TRAP(7);
BUILD_ERR_TRAP(8);
BUILD_TRAP(9);
BUILD_ERR_TRAP(10);
BUILD_ERR_TRAP(11);
BUILD_ERR_TRAP(12);
BUILD_ERR_TRAP(13);
BUILD_ERR_TRAP(14);
BUILD_TRAP(15);
BUILD_TRAP(16);
BUILD_TRAP(17);
BUILD_TRAP(18);
BUILD_TRAP(19);
BUILD_TRAP(20);
BUILD_TRAP(21);
BUILD_TRAP(22);
BUILD_TRAP(23);
BUILD_TRAP(24);
BUILD_TRAP(25);
BUILD_TRAP(26);
BUILD_TRAP(27);
BUILD_TRAP(28);
BUILD_TRAP(29);
BUILD_TRAP(30);
BUILD_TRAP(31);

void (*trap_func[])(void) = {
  trap_0,  trap_1,  trap_2,  trap_3,  trap_4,  trap_5,  trap_6,  trap_7,
  trap_8,  trap_9,  trap_10, trap_11, trap_12, trap_13, trap_14, trap_15,
  trap_16, trap_17, trap_18, trap_19, trap_20, trap_21, trap_22, trap_23,
  trap_24, trap_25, trap_26, trap_27, trap_28, trap_29, trap_30, trap_31
};

PUBLIC void init_traps(void)
     /* set up the trap gates */
{
  int i;
  
  for (i=0; i < TRAP_VECTORS; i++)
    set_trap_gate(i, trap_func[i]);
#if DEBUG_LOCAL
  printk("Traps initialized.\n");
#endif
}

extern void show_frame(void);

/* PRIVATE */ void 
trap(unsigned long trap_no)
     /* change this sometimes */
{
  cli();
  printk("trap %ld", trap_no);
  if (trap_no <= 16) printk("= %s\n", trap_txt[trap_no]);
  printk("eip : %lx cs : %lx flags : %lx (esp : %lx ss : %lx)\n",
	 trap_eip, trap_cs, trap_flags, trap_esp, trap_ss);
  show_frame();
  panic("UNEXPECTED TRAP %d", trap_no);
}

/* PRIVATE */ void
trap_err(unsigned long trap_no)

{
  cli();
  printk("trap %ld", trap_no);
  if (trap_no <= 16) printk(" = %s;", trap_txt[trap_no]);
  printk(" error code 0x%lx\n", trap_error);
  printk("eip : %lx cs : %lx flags : %lx (esp : %lx ss : %lx)\n",
	 trap_eip, trap_cs, trap_flags, trap_esp, trap_ss);
  show_frame();
  panic("UNEXPECTED TRAP %d", trap_no);
}
