/* 
 * params.h
 * @(#) parameters saved by boot/setup.S describing the machine
 * (c) 1995 by Mihai Budiu
 */

#ifndef _PARAMS_H
#define _PARAMS_H

struct drive_info_struct { char info[32]; };
struct screen_info {
  unsigned char  orig_x;
  unsigned char  orig_y;
  unsigned char  unused1[2];
  unsigned short orig_video_page;
  unsigned char  orig_video_mode;
  unsigned char  orig_video_cols;
  unsigned short orig_video_ega_ax;
  unsigned short orig_video_ega_bx;
  unsigned short orig_video_ega_cx;
  unsigned char  orig_video_lines;
};

#define PARAM	save_boot_params.s
#define EXT_MEM_K         (*(unsigned short *) (PARAM+2))
#define DRIVE_INFO        (*(struct drive_info_struct *) (PARAM+0x80))
#define SCREEN_INFO       (*(struct screen_info *) (PARAM+0))
#define SCREEN_INFOP       ((struct screen_info *) (PARAM+0))
#define MOUNT_ROOT_RDONLY (*(unsigned short *) (PARAM+0x1F2))
#define SYSTEM_SIZE       (*(unsigned short *) (PARAM + 0x1F4)) /* by build */
#define SWAP_DEV          (*(unsigned short *) (PARAM + 0x1F6))
#define RAMDISK_SIZE      (*(unsigned short *) (PARAM+0x1F8))
#define ORIG_ROOT_DEV     (*(unsigned short *) (PARAM+0x1FC)) /* by build */
#define AUX_DEVICE_INFO   (*(unsigned char *) (PARAM+0x1FF))
/* these are the places where setup.S & build.c saved various
   descriptions of the machine; they are hardcoded there, so it is
   pretty difficult to alter their positions.  I didn't dare, so I
   kept the layout used by the Linux setup.S (that I shamelessly
   adopted). */

/* now follow the places where tools/build places descriptions of the
   initial system configuration ! */

struct configuration {
  unsigned long base; 
  unsigned long code_size; 
  unsigned long data_size; /* incl bss */
  unsigned long stack_size;
  unsigned long entry;
  char proc_name[sizeof(long) * 3];  /* process name */
  /* the last field is such as *no* padding must exist between two consecutive
     structures configuration in an array; see how tools/build.c works.
     */
};

extern union prm {
  unsigned char s[2048]; /* this size is hardcoded in head.S ! */
  long l;  /* for alignament */
} save_boot_params;
    /* zone to save the boot parameters; put here by boot/head.S */

#endif /* _PARAMS_H */
