/* 
 * misc.c
 * (c) 1995 by Mihai Budiu
 * #(@) kernel developement support routines
 */

#include <stdarg.h>
#include "./params.h"
#include "../include/globals.h"
#include "../include/io.h"
#include "../include/asm.h"

#define KER_SCR_H 13 /* this many lines for kernel log on lower screen */

/* some debugging code - direct access to video memory */

PRIVATE unsigned char * vid_mem = (unsigned char *)0xb8000;
PRIVATE unsigned char lines = 0, 
                      columns=0; /* screen dimensions */

PUBLIC unsigned char * get_vid_mem_start(void)
{
  return vid_mem;
}

PRIVATE void scroll(void)

{
  int i;
  for (i=0; i < (lines-1) * columns * 2; i++) 
    vid_mem[i] = vid_mem[i+ columns * 2];
  for (i = (lines - 1) * columns * 2; i < lines * columns * 2; i+=2) 
    vid_mem[i] = ' ';
}
  
PRIVATE void puts(unsigned char * text)

{ char *p = text;
  unsigned char x, y;
  unsigned char c;

  x = SCREEN_INFO.orig_x;
  y = SCREEN_INFO.orig_y;

  while((c = *(p++)) != '\0') {
    if(c == '\n') {
      x = 0;
      if (++y >= lines) {
	--y;
	scroll();
      }
    }
    else if ((c < 32) || (c > 127)) continue;
    else {
      vid_mem[(x + columns * y) * 2] = c;
      if ( ++x >= columns ) {
	x = 0;
	if (++y >= lines) {
	  --y;
	  scroll();
	}
      }
    }
  }
  SCREEN_INFO.orig_x = x;
  SCREEN_INFO.orig_y = y;  
}

PUBLIC void init_puts(void)
  
{
  int i;
  if (SCREEN_INFO.orig_video_mode == 7) vid_mem = (unsigned char *) 0xb0000;
  else vid_mem = (unsigned char *) 0xb8000;
  
  lines = SCREEN_INFO.orig_video_lines;
  columns = SCREEN_INFO.orig_video_cols;
  for (i=0; i < lines * columns; i++) vid_mem[2*i] = ' ';
  SCREEN_INFO.orig_x = 0;
  SCREEN_INFO.orig_y = 0;
  vid_mem += (lines - KER_SCR_H) * 2 * columns;
  lines = KER_SCR_H;
}

PUBLIC int printk(const char *fmt, ...)
{
  va_list args;
  int i;
  char bigtext[256];  /* very, very long line */
  unsigned long fl;
 
  save_flags(fl);
  cli();
  va_start(args, fmt);
  i=vsprintf(bigtext, fmt, args);
  va_end(args);
  puts((unsigned char *)bigtext);
  restore_flags(fl);
  return i;
}
