/*
 * kernel/int_proc.c
 * @(#) interrupt preprocessing to message
 * (C) 1995 by Mihai Budiu
 */

#include "../include/globals.h"
#include "../include/error.h"
#include "../include/asm.h"
#include "./proc.h"

#define ERR_MESS 0  /* no error messages */

/************************ keyboard handling part *********************/
PRE_INT ad_key;

#if 0
PRIVATE inline void kb_wait(void)
     /* delay till keyboard ready */
{
  int i;
  unsigned char c;

  for (i=0; i<0x10000; i++) {
    inb(c, 0x64);
    very_slow();
    if ((c & 0x02) == 0) break;
  }
}

PRIVATE void send_cmd(unsigned char c)
     /* send a command to the keyboard */
{
  kb_wait();
  outb(c, 0x64);
}
#endif /* 0 */

#if DEBUG
extern void show_queues(void);
extern void show_task(int);
#endif

PUBLIC int ad_key(struct message * m)
     /* build message from a keyboard int */
{
  int result;
  unsigned char c, scancode;

#if 0                         /* didn't work this way ... */
  send_cmd(0xAD);             /* disable keyboard */
  kb_wait();
  inb(c, 0x64);               /* status */
  very_slow();
  if ((c & 0x01) != 0x01) {   /* no useful information; no message */
    result = -1;
    goto end_kbd_intr;  
  }
#endif
  inb(scancode, 0x60);        /* scan code of key struck */
  very_slow();
  inb(c, 0x61);               /* ack the char */
  very_slow();
  outb(c | 0x80, 0x61);       /* strobe the bit high */
  very_slow();
  outb(c & 0x7f, 0x61);       /* now low */
  very_slow();
  if (scancode == 0xfa) {
#if ERR_MESS
    printk("acknowledge requested\n");
#endif
    result = -1;
    goto end_kbd_intr;
  } else if (scancode == 0xfe) {
#if ERR_MESS
    printk("resend requested\n");
#endif
    result = -1;
    goto end_kbd_intr;
  } else if (scancode == 0) {
#if ERR_MESS
    printk("keyboard buf overflow\n");
#endif
    result = -1;
    goto end_kbd_intr;
  } else if (scancode == 0xff) {
#if ERR_MESS
    printk("keyboard error\n");
#endif
    result = -1;
    goto end_kbd_intr;
  }

#if DEBUG     /* debugging dumps */
  if (scancode == 1) show_queues();  /* ESC */
  else if (scancode >= 0x3b && scancode <= 0x44) {
    show_task(scancode - 0x3b);  /* F1 - F10 */
    printk("------------------------\n");
  }
#endif

  /* no error; put the scancode in the message; the ERROR field of
     the message shows the current pending interrupt no. */
  if (m->ERROR >= sizeof(m->INFOc)) { /* no more place to fit char */
    result = -1;
    goto end_kbd_intr;
  }
  m->INFOc[m->ERROR] = (char)scancode;
  result = E_OK;
 end_kbd_intr:
#if 0                         /* this goes in pair with upper cmd */
  send_cmd(0xAE);             /* re-enable keyboard */
#endif
  return result;
}

PUBLIC int ad_time(struct message * m)

{
  if (m->ERROR) printk("timer pend %d\n", m->ERROR);
  return E_OK;
}



