/*
 * error.c
 * @(#) handling internal system errors
 * (c) 1995 by Mihai Budiu
 */

#include "../include/globals.h"
#include "../include/error.h"
#include "../include/asm.h"

extern int printk(const char *, ...);

PUBLIC void panic(char * text, int info)
/* fatal error; stop execution; handle one numeric argument */
{
  cli();    /* interrupts not useful anymore */
  printk("\n*** KERNEL PANIC ! ***\n");
  printk(text, info);  /* display panic information */
  printk("\n*** SYSTEM HALTED ! ***\n");
  for(;;);    /* no other solution ! */
}

