/* 
 * desc.h
 * @(#) descriptor handling declarations
 * (c) 1995 by Mihai Budiu
 */

#ifndef _DESC_H
#define _DESC_H

/* fake representation for a descriptor */

struct descriptor {
  long a, b;
};
extern struct descriptor gdt[], idt[];

/* various types for descriptors */
#define TYPE_DATA_RO    0x90
#define TYPE_DATA_RW    0x92
#define TYPE_CODE       0x98
#define TYPE_CODE_RO    0x9A
#define TYPE_CODE_CF    0x9C    /* conformal segment */
#define TYPE_CODE_CF_RO 0x9E

#define TYPE_LDT        0x82
#define TYPE_TASK_GATE  0x85
#define TYPE_TSS        0x89
#define TYPE_CALL_GATE  0x8C
#define TYPE_INT_GATE   0x8E
#define TYPE_TRAP_GATE  0x8F

int set_tss_descriptor(int task_no);
     /* set up a tss descriptor */
int set_interrupt_gate(int int_no, void (*handler)(void));
     /* build that interrupt gate */
int set_trap_gate(int trap_no, void (*handler)(void));
     /* build a trap gate */
int set_ldt_descriptor(int task_no, struct descriptor * ldtbase, 
		       unsigned long ldtsize, int privilege);
     /* build a ldt descriptor */
char * get_base(struct descriptor * addr);
     /* get the base address of a descriptor at addr */
char * get_displacement(struct descriptor * addr);
     /* this is a gate; get displacement */
unsigned long get_limit(struct descriptor * addr);
     /* get the limit of a descriptor */
void set_descriptor(struct descriptor * addr, char * base, 
	       unsigned long limit, unsigned char type, int privilege);
     /* set up all the fields of a segment descriptor */
int set_sys_call_gate(int int_no, void (*handler)(void));
     /* set up a system call gate (a trap gate !) */

#if DEBUG
void show_descriptor(struct descriptor * addr);
#endif

#endif
