/*
 * include/unistd.h
 * @(#) system call library
 * (c) 1995 by Mihai Budiu
 */

#ifndef _UNISTD_H
#define _UNISDT_H
#include "./message.h"

#if defined(__KERNEL__) || defined(__LIB__)
/* system call number */
#define SEND     01
#define RECEIVE  02
#define SEND_REC 03
/* that's all folks ! :-) */

#define SYS_CALL_INT 0x80  /* system call gate */
/* 
   the syscall is a library function.
   It has one operation code and a message pointer;
   the message itself contains the source / destination 
 */

#ifdef __LIB__
#define _STR(x) #x
#define STR(x) _STR(x)

static inline int sys_call(int send_rec, struct message * user_mesgptr)
{ 
  long result;

  __asm__ volatile
 (
  "int $" STR(SYS_CALL_INT)
  : "=a" (result)
  : "0" ((unsigned long)send_rec), "b" ((unsigned long)user_mesgptr)
  : "memory"
  );
  return (int) result;
}
#undef STR
#undef _STR
#endif /* __LIB__ */
#endif /* __KERNEL__ || __LIB__ */
#endif /* _UNISTD_H */
