/* segment.h
 * #(@) values to be loaded in the segment registers to access various data 
 * (c) 1995 by Mihai Budiu
 */

#ifndef _SEGMENT_H
#define _SEGMENT_H
#include "./globals.h"

#define GLOB_DESC_PER_PROC 2      
/* each process has 2 global descriptors : TSS & LDT */
#define FIRST_PROC_DESCRIPTOR  6 
/* starting from this slot in the gdt are processes */

/* this is sometimes useful */
#define NULL_SELECTOR ((unsigned short) 0)

/* selector attribute */
#define LOCAL  0x04  /* from ldt */
#define GLOBAL 0x00  /* from gdt */

/* privilege levels */
#define KERNEL_PRIV 0
#define DRIVER_PRIV 1 /* unused now */
#define SERVER_PRIV 2 /* unused now */
#define USER_PRIV   3

/* kernel descriptor numbers */

#define KERNEL_CS_DESCRIPTOR 2  /* no. 3 in gdt table; hardcoded in head.S */
#define KERNEL_DS_DESCRIPTOR 3

#define TSS_DESCRIPTOR(task_no) \
   (FIRST_PROC_DESCRIPTOR + (task_no)*GLOB_DESC_PER_PROC)
#define LDT_DESCRIPTOR(task_no) (TSS_DESCRIPTOR(task_no) + 1)

/* some selectors for gdt */

#define KERNEL_CS  0x10 
 /* ((KERNEL_CS_DESCRIPTOR << 3) | GLOBAL | KERNEL_PRIV); constant for boot.S
    (the as86 assembler does not accept such an expression) */
#define KERNEL_DS  0x18 
 /* ((KERNEL_DS_DESCRIPTOR << 3) | GLOBAL | KERNEL_PRIV) */
#define KERNEL_SS  ((KERNEL_SS_DESCRIPTOR << 3) | GLOBAL | KERNEL_PRIV) 

#if DEBUG
#define SCREEN_SELECTOR 0x0b
#endif

#define TSS(n) ( (TSS_DESCRIPTOR(n) << 3) | GLOBAL | KERNEL_PRIV)
#define LDT(n) ( (LDT_DESCRIPTOR(n) << 3) | GLOBAL | USER_PRIV)
  /* ldt's are used only by user processes */
/* the CS, DS and SS DESCRIPTOR #s in the ldt */
#define USER_CS_DESCRIPTOR   0
#define USER_DS_DESCRIPTOR   1
#define USER_SS_DESCRIPTOR   2

/* the selectors for user space */
#define USER_CS    ( (USER_CS_DESCRIPTOR << 3) | LOCAL | USER_PRIV )
#define USER_DS    ( (USER_DS_DESCRIPTOR << 3) | LOCAL | USER_PRIV )
#define USER_SS    ( (USER_SS_DESCRIPTOR << 3) | LOCAL | USER_PRIV )

#endif



