/*
 * pid.h
 * @(#) process id structure for Pico
 * (c) 1995 by Mihai Budiu
 */

#ifndef _PID_H
#define _PID_H

typedef unsigned long LOCAL_PID;

typedef struct proc_id {  /* process id; we make it */
  LOCAL_PID local_pid;    /* rather large, to fit a 
			     distributed design */
#if 0
  unsigned int thread;    /* multithreading is expected to come sometimes */
  unsigned long machine;  /* also 'distributivity' */
#endif
} proc_id;

/* local pids for some usual processes (correspond to slots initially) : 
 * THESE HAVE TO COINCIDE WITH THE ORDER OF THE SERVERS IN THE
 * INITIAL SYSTEM IMAGE
 */
#define IDLE_PID    0
#define ANY_PID  IDLE_PID  /* used for receiving; IDLE never sends anything */
#define SYS_PID     1
#define CLOCK_PID   2
#define MM_PID      3
#define SCAN_PID    4
#define KEY_PID     5
#define SCREEN_PID  6

#endif
