/*
 * include/operation.h
 * @(#) operation codes for servers conversations
 * (c) 1995 by Mihai Budiu
 */

#ifndef _OPERATION_H
#define _OPERATION_H

/* operation codes */
/******************** for all servers *********************/
#define INT     0  /* an interrupt has come; for all interrupt handlers ! */
/* arguments : 
   INFO depends on type; 
   on MSGID keep the interrupt no ! 
   on ERROR number of pending interrupts */
#define DUMP   -1  /* I'm debugging you; please dump */
/* arguments : none */
#define NOOP   -2  /* no operation at all; used for unblocking;
		      ignored by most servers; should not occur at all */
/* arguments : none */
#define GIVE_DATA -3 /* after a signal client asks for data again */
/* arguments : none */
#define SIGNAL -4  /* this is a fake signal message built by the kernel */
/* arguments : none */

/********************** for the system task ****************/
#define NEW_PROC   1 /* build a process from a given map */
/* arguments : memory map */
#define KILL_PROC  2 /* destroy an existing process */
/* arguments : proc_id = process to be destroyed */
#define HAND_INT   3 /* register as an interrupt handler */
/* arguments : int = interrupt number */
#define UNHAND_INT 4 /* unregister an interrupt handler */
/* arguments : int = interrupt # */
#define CH_PRIO    5 /* change the priority */
/* arguments : int = new priority */
#define SRV_PANIC  6 /* some server panices */
/* arguments : int, char[] = error, text */
#define SRV_ERROR  7 /* some server has an error */
/* arguments : int, char[] = error, text */
#define SRV_MESS   8 /* some server has a message */
/* arguments : int, char[] = error, text */
#define GET_DATA   9 /* servers ask about system configuration */
enum {
  CONFIG_DATA,  /* used by mm */
  SCREEN_DATA,
  RAM_DATA,
  HD_DATA
};
/* aguments : enum = what data necessary */
#define DO_SIGNAL 10 /* signal somebody */
/* arguments : 
   INFO = proc_id to signal. 
   SIGNAL_ME = signal number.
*/

/******************** for the clock task **********************/
#define SLEEP      1 /* sleep.  Hopefully blocking. */
/* arguments : unsigned long = time to sleep */
#define TIME       2 /* get times (ticks, u_time, s_time) */
/* arguments : none */

/******************** for the keyboard scan code server *******************/
#define SCAN_GET   1 /* scan code of the key depressed/released.  Blocking. */
/* arguments : none */
#define SCAN_NOW   2 /* tell me if any key depressed/released. Not blocking. */
/* arguments : none */
#define SCAN_MODE  3 /* new functioning mode */
/* arguments : unsigned int = mode flags, as below*/
enum {
  SCAN_CIRCULAR    = 1, /* circular buffering - only last keys (for games) */
  SCAN_FILTER_MOST = 2, /* do not record release of most keys */
  SCAN_FILTER_PREFIX=4  /* filter the 0xe0 & 0xe1 prefixes of keys */
};
#define SCAN_GET_MODE 4 /* read the functioning mode */
/* arguments : none */

/******************* for the keyboard key code server *****************/
#define KEY_GET   1 /* tell me the code of the key pressed.  Blocking. */
/* arguments : none */

/******************* for the screen server *********************/
#define SHOW_CHAR 1 /* print one character on the screen */
/* arguments : char = char to print */

#endif
