/*
 * memobj.h
 * @(#) memory object related definitions
 * (c) 1995 by Mihai Budiu for Pico
 */

#ifndef _MEMOBJ_H
#define _MEMOBJ_H

struct mem_obj_id {
  unsigned long obj_id;     /* unique distributed id for the object */
  unsigned long attributes1;/* attributes the object has */
};

/* various attributes */
enum {
  MAPPED =   00001L,   /* it is mapped in at least one memory space */
  SHARABLE = 00002L,   /* may be shared */
  EXECUTABLE=00004L,   /* may be executed */
  READABLE  =00010L,   /* may be read */
  WRITABLE  =00020L,   /* may be modified */
  ERRANT    =00040L    /* may migrate */
};

#endif
