/*
 * error.h
 * @(#) error handling procedures for kernel
 * (c) 1995 by Mihai Budiu
 */

#ifndef _ERROR_H
#define _ERROR_H

void panic(char * text, int info);
  /* fatal error in kernel ! */

/* some error codes; all negative numbers */
#define E_OK       0    /* no error */
#define E_BADARG  -1    /* bad argument in function call */
#define E_OUTSP   -2    /* out of space for something */
#define E_NOSLOT  -3    /* process table full ! */
#define E_ILL     -4    /* illegal action */
#define E_READY   -5    /* this task is still ready */
#define E_BADOP   -6    /* bad operation asked from server */
#define E_NOPID   -7    /* no such process id */
#define E_STKSML  -8    /* stack to small */
#define E_ZOMBIE  -9    /* killed process remained zombie */
#define E_AGAIN  -10    /* cannot do this operation now; retry later */
#define E_BUSY   -11    /* resource busy */
#define E_BLOCK  -12    /* process must block; (used internally) */
#endif

