/* 
 * include/config.h 
 * some definitions for boot time for PicOs
 * adapted from <linux/config.h> by Mihai Budiu
 */

#ifndef _CONFIG_H
#define _CONFIG_H

/* Don't touch these, unless you really know what your doing. */

#define DEF_INITSEG	0x9000
#define DEF_SYSSEG	0x1000
#define DEF_SETUPSEG	0x9020
#define DEF_SYSSIZE	0x7F00

/* internal svga startup constants */
#define NORMAL_VGA	0xffff		/* 80x25 mode */
#define EXTENDED_VGA	0xfffe		/* 80x50 mode */
#define ASK_VGA		0xfffd		/* ask for it at bootup */

#define FIRST_HARD_INT 0x20    /* here setup.S moves first hard interrupt */
#define HARD_INT_VECTORS 16    /* hardcoded in kernel/interrupt.c */
#define TRAP_VECTORS 32        /* hardcoded in kernel/trap.c */
#define INT_VECTORS 256    /* a bit late this; should parametrize head.S too */

#define INIT_SERVERS  7        /* number of servers when system brought up */

/* some interrupt & irq numbers */

#define TIMER_IRQ    0
#define KEYBOARD_IRQ 1
#define FLOPPY_IRQ   6
#define HD_IRQ      14

#define TIMER_INT    (FIRST_HARD_INT + TIMER_IRQ)
#define HD_INT       (FIRST_HARD_INT + HD_IRQ)
#define KEYBOARD_INT (FIRST_HARD_INT + KEYBOARD_IRQ)
#define FLOPPY_INT   (FIRST_HARD_INT + FLOPPY_IRQ)

/* priorities */
#define PRIO_LEVELS  5  /* number of priority levels */

#define KERNEL_PRIO  0  /* priority of the kernel tasks */
#define DRIVER_PRIO  1  /* priority of the drivers */
#define SERVER_PRIO  2  /* main servers (eg. mm) */
#define USER_PRIO    3  /* user processes */
#define IDLE_PRIO    4  /* idle when nothing else to do */

#define THRESHOLD_PRIO 2 /* less or equal this cannot be preempted */

#endif
