/* 
 * asm.h
 * @(#) some assembly code that HAS to be inlined
 * (c) 1995 by Mihai Budiu
 * hints from Linux code
 */

#define sti() __asm__ __volatile__ ("sti":::"memory")
#define cli() __asm__ __volatile__ ("cli":::"memory")
#define nop() __asm__ __volatile__ ("nop")

#define save_flags(x) \
__asm__ __volatile__("pushfl ; popl %0":"=r" (x): /* no input */ :"memory")
#define restore_flags(x) \
__asm__ __volatile__("pushl %0 ; popfl": /* no output */ :"r" (x):"memory")

#define outb(byte, port) \
__asm__ __volatile__("outb %b0, %w1" : :"a" (byte), "d" (port))
#define inb(byte, port) \
__asm__ __volatile__("inb %w1, %b0" : "=a"(byte) : "d" (port))
#define slow() \
__asm__ __volatile__("jmp 1f\n1:\tjmp 1f\n1:\t")
#define very_slow() \
do { slow(); slow(); slow(); slow(); } while (0)

#define ltr(selector) \
__asm__ __volatile__("ltr %w0" : : "a" (selector))

/* next macros used for trap/interrupt handling */
#define SAVE_REGS \
	"cld\n\t" \
	"push %gs \n\t" \
	"push %fs \n\t" \
	"push %es \n\t" \
	"push %ds \n\t" \
	"pushl %ebx\n\t" \
	"pushl %ecx\n\t" \
	"pushl %edx\n\t" \
	"pushl %esi\n\t" \
	"pushl %edi\n\t" \
	"pushl %ebp\n\t" \
	"pushl %eax\n\t" 
/* EAX must be pushed last. Don't change here unless also in 
   sys_call.c and task.c ! */

struct stack_regs {  /* access through such the saved registers
			during an interrupt / exception treatment */
  unsigned long eax;
  unsigned long ebp;
  unsigned long edi;
  unsigned long esi;
  unsigned long edx;
  unsigned long ecx;
  unsigned long ebx;
  unsigned long ds;
  unsigned long es;
  unsigned long fs;
  unsigned long gs;
  unsigned long eip;
  unsigned long cs;
  unsigned long flags;
  unsigned long esp;
  unsigned long ss;
};

#define RESTORE_REGS \
	"popl  %eax\n\t" \
	"popl  %ebp\n\t" \
	"popl  %edi\n\t" \
	"popl  %esi\n\t" \
	"popl  %edx\n\t" \
	"popl  %ecx\n\t" \
	"popl  %ebx\n\t" \
	"pop  %ds \n\t" \
	"pop  %es \n\t" \
	"pop  %fs \n\t" \
	"pop  %gs \n\t" 

#define get_ip(var) \
  __asm__ __volatile__("call 1f\n1:\tpopl %0\n" : "=r" (var)) 
#define get_sp(var) \
  __asm__ __volatile__("movl %%esp, %0\n" : "=r" (var))

/* this is a jmp address (indirect jump) */
#define jmp_far(add48) \
  __asm__ __volatile__("ljmp %0": :"m" (*add48): "memory")


