/*
 * boot/head.S
 *
 * (C) Linus Torvalds, modified Mihai Budiu for own purposes
 * @(#) contains the 32-bit startup code.
 */

#include "../include/limits.h"
#include "../include/segment.h"

.text
.globl _gdt, _idt, _gdtend, _idtend, _printk

startup_32:
	cld
	cli
	movl $(KERNEL_DS),%eax
	mov %ax,%ds
	mov %ax,%es
	mov %ax,%fs
	mov %ax,%gs
	lss _k_stack_start,%esp

	xorl %eax,%eax
1:	incl %eax		# check that A20 really IS enabled
	movl %eax,0x000000	# loop forever if it isn't
	cmpl %eax,0x100000
	je 1b
/*
 * Initialize eflags.  Some BIOS's leave bits like NT set.  This would
 * confuse the debugger if this code is traced.
 */
	pushl $0
	popfl
/* Clear BSS */

	xorl %eax,%eax
	movl $__edata,%edi
	movl $__end,%ecx
	subl %edi,%ecx
	cld
	rep
	stosb
/* initialize idt */
	call setup_idt
/* Copy bootup parameters out of the way. */
	movl $0x90000,%esi
	movl $_save_boot_params,%edi
	movl $512,%ecx
	cld
	rep
	movsl
/* check if it is 486 or 386. */

	movl %esp,%edi		# save stack pointer
	andl $0xfffffffc,%esp	# align stack to avoid AC fault
	movl $3,_x86
	pushfl			# push EFLAGS
	popl %eax		# get EFLAGS
	movl %eax,%ecx		# save original EFLAGS
	xorl $0x40000,%eax	# flip AC bit in EFLAGS
	pushl %eax		# copy to EFLAGS
	popfl			# set EFLAGS
	pushfl			# get new EFLAGS
	popl %eax		# put it in eax
	xorl %ecx,%eax		# change in flags
	andl $0x40000,%eax	# check if AC bit changed
	je is386
	movl $4,_x86
	movl %ecx,%eax
	xorl $0x200000,%eax	# check ID flag
	pushl %eax
	popfl			# if we are on a straight 486DX, SX, or
	pushfl			# 487SX we can't change it
	popl %eax
	xorl %ecx,%eax
	andl $0x200000,%eax
	je is486
isnew:	pushl %ecx		# restore original EFLAGS
	popfl
	movl $1, %eax		# Use the CPUID instruction to 
	.byte 0x0f, 0xa2	# check the processor type
	andl $0xf00, %eax	# Set _x86 with the family
	shrl $8, %eax		# returned.	
	movl %eax, _x86
	movl %edi,%esp		# restore esp
	movl %cr0,%eax		# 486+
	andl $0x80000011,%eax	# Save PG,PE,ET
	orl $0x50022,%eax	# set AM, WP, NE and MP
	jmp 2f
is486:	pushl %ecx		# restore original EFLAGS
	popfl
	movl %edi,%esp		# restore esp
	movl %cr0,%eax		# 486
	andl $0x80000011,%eax	# Save PG,PE,ET
	orl $0x50022,%eax	# set AM, WP, NE and MP
	jmp 2f
is386:	pushl %ecx		# restore original EFLAGS
	popfl
	movl %edi,%esp		# restore esp
	movl %cr0,%eax		# 386
	andl $0x80000011,%eax	# Save PG,PE,ET
	orl $2,%eax		# set MP
2:	movl %eax,%cr0

/* does anybody help us in math ? */
	call check_x87
/*
 * better to rebuild the Global Descriptor Table, 
 * as the one set up by boot/Setup.S might be sometimes
 * overlaid; anyhow it wasn't in any way mapped in a
 * symbol of our code, being linked sepparately.
 * We need to have access to gdt (and idt too) from the
 * C code also.
 * The idt was null up to now
 */
	lgdt gdt_descr
	lidt idt_descr
	ljmp $(KERNEL_CS), $1f
1:	movl $(KERNEL_DS), %eax # reload segment registers
	mov %ax, %ds
	mov %ax, %es
	mov %ax, %fs
	mov %ax, %gs
	lss _k_stack_start, %esp
	xorl %eax, %eax
	lldt %ax
	pushl %eax
	pushl %eax
	pushl %eax
 
	cld	# gcc2 wants the direction flag cleared at all times
	call _start_kernel	# this is already C compiled
notreach:
	jmp notreach		# main should never return here, but
				# just in case, we know what happens.

/* routines */

/* We depend on ET to be correct. This checks for 287/387. */
check_x87:
	movl $0,_hard_math
	clts
	fninit
	fstsw %ax
	cmpb $0,%al
	je 1f
	movl %cr0,%eax		/* no coprocessor: have to set bits */
	xorl $4,%eax		/* set EM */
	movl %eax,%cr0
	ret
.align 2
1:	movl $1,_hard_math
	.byte 0xDB,0xE4		/* fsetpm for 287, ignored by 387 */
	ret

/*
 *  setup_idt
 *
 *  sets up a idt with 256 entries pointing to
 *  ignore_int, interrupt gates. It doesn't actually load idt 
 */
setup_idt:
	lea ignore_int,%edx
	movl $(KERNEL_CS << 16),%eax
				/* %eax = SELECTOR << 16 | 00 */
	movw %dx,%ax		/* %eax = SELECTOR << 16 | ignore_int(0-15) */
	movw $0x8E00,%dx	/* interrupt gate - dpl=0, present */
				/* edx = ignore_int(16-32) << 16 | flags */
	lea _idt,%edi
       	mov $256,%ecx		/* set up 256 interrupt gates */
rp_sidt:
	movl %eax,(%edi)	/* build the interrupt gate */
	movl %edx,4(%edi)
	addl $8,%edi
	dec %ecx
	jne rp_sidt
	ret

int_msg: .ascii "Unexpected interrupt\10\0"
/* This is the default interrupt "handler" */
.align 2
ignore_int:
	cld
	pushl %eax
	pushl %ebx
	pushl %ecx
	pushl %edx
	pushl %esi
	pushl %edi
	pushl %ebp
	push %ds
	movl $(KERNEL_DS),%eax
	mov %ax,%ds
	pushl $int_msg
	call _printk
	addl $4, %esp
	pop %ds
	popl %ebp
	popl %edi
	popl %esi
	popl %edx
	popl %ecx
	popl %ebx
	popl %eax
	iret

/*
 * The interrupt descriptor table has room for 256 idt's
 */
.align 4
.word 0
idt_descr:
	.word 256*8 - 1 # idt contains 256 entries
	.long _idt

.align 4
_idt:
	.fill 256,8,0		# idt is uninitialized
_idtend:

.align 4
.word 0
gdt_descr:
	.word _gdtend - _gdt - 1
	.long _gdt
/*
 * warning ! these descriptors are refered also from ../include/segment.h
 * and have to coincide with those in ./setup.S
 */
.align 4
_gdt:
	.quad 0x0000000000000000	/* NULL descriptor */
	.quad 0x0000000000000000	/* not used */
	.quad 0x00c09a00000003ff	/* 0x10 kernel 4MB code at 0 */
	.quad 0x00c09200000003ff	/* 0x18 kernel 4MB data at 0 */
	.quad 0x0000000000000000	/* not used */
	.quad 0x0000000000000000	/* not used */
	.fill GLOB_DESC_PER_PROC * NR_TASKS,8,0	
		/* space for TSS's and LDT's */
_gdtend:

