/*
 * HexRegions.java
 *  
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

public class TriangleRegions extends HexZones {
		
	public class Triangle {
		public  Point a,b,c;
		public String toString() {
			return "[(" + a.x + "," + a.y+ "),(" + 
						  b.x + "," + b.y+ "),(" + 
						  c.x + "," + c.y+ ")]"; 
		}
		
		public int fAB(Point p) {return (p.y-a.y)*(b.x-a.x) - (p.x-a.x)*(b.y-a.y);}
		
		public int fBC(Point p) {return (p.y-b.y)*(c.x-b.x) - (p.x-b.x)*(c.y-b.y);}
		
		public int fCA(Point p) {return (p.y-c.y)*(a.x-c.x) - (p.x-c.x)*(a.y-c.y);}
		
		public boolean ptInside(Point p) {
			if ((fAB(p)*fBC(p)>0) && (fCA(p)*fBC(p)>0)) return true;
			else return false;
		}
		public Point minPt() {
			Point p = new Point(100000,1000000);
			if (a.x < p.x) p.x = a.x;
			if (b.x < p.x) p.x = b.x;
			if (c.x < p.x) p.x = c.x;
			if (a.y < p.y) p.y = a.y;
			if (b.y < p.y) p.y = b.y;
			if (c.y < p.y) p.y = c.y;
			return p;
		}		
		public Point maxPt() {
			Point p = new Point(0,0);
			if (a.x > p.x) p.x = a.x;
			if (b.x > p.x) p.x = b.x;
			if (c.x > p.x) p.x = c.x;
			if (a.y > p.y) p.y = a.y;
			if (b.y > p.y) p.y = b.y;
			if (c.y > p.y) p.y = c.y;
			return p;
		}
		
		public Point ctr() {
			Point p = new Point();
			p.x = (a.x + b.x + c.x) / 3;
			p.y = (a.y + b.y + c.y) / 3;
			return p;
		}
		
		//flip triangle over line separating a from b&c
		public Triangle flipTriangle() {
			Triangle t = new Triangle();
			t.a = new Point((b.x+c.x)/2, (b.y+c.y)/2);
			Point midBvector = new Point(b.x-t.a.x,b.y-t.a.y);
			Point midCvector = new Point(c.x-t.a.x,c.y-t.a.y);
			t.b = new Point (a.x+midBvector.x,a.y+midBvector.y);
			t.c = new Point (a.x+midCvector.x,a.y+midCvector.y);
			return t;
		}
	}
	
	public class TriRegion {
		public Triangle r;
		public boolean fill;
		public int collapseDir;
		public int triX,triY; //coordinates in tesselated grid of triangles
		public String toString() {
			return "tri_region: " + r.toString() + ",normal: " 
					+ collapseDir + ",fill: " + fill;
		}
		public boolean ptInside(Point p) { return r.ptInside(p);}
		public boolean ptInside(int x,int y) {return r.ptInside(new Point(x,y));}
	}
	
	public Point hexPt(Point ctr,Point r,int offset) {
		double dist = ctr.distance(r);
		double theta = offset * 60 - 30; //degrees
		theta = Math.toRadians(theta);
		Point out = new Point();
		out.x = (int) Math.round(dist*Math.cos(theta) + ctr.x);
		out.y = (int) Math.round(dist*Math.sin(theta) + ctr.y);
		return out;
	}
	
	public Triangle getT(Point start,Point end) {
		Triangle t = new Triangle();
		t.a = start;
		double minDist = 1000000000.0;
		for (int i = 1; i < 7; i++) {
			Point temp = hexPt(start,end,i);
			if (temp.distance(end) < minDist) {
				minDist = temp.distance(end);
				t.b = temp;
				t.c = hexPt(start,end,shiftDir(i,1));
			}
		}
		return t;
	}
	
	public int getNormal(Point start,Point end) {
		int out = 0;
		double minDist = 1000000000.0;
		for (int i = 1; i < 7; i++) {
			Point temp = hexPt(start,end,i);
			if (temp.distance(end) < minDist) {
				minDist = temp.distance(end);
				out = i;
			}
		}
		return shiftDir(out,3);
	}
	
	public Point screenToArray(int x,int y) {
		int y_coord = (int) Math.floor((y * 1.0) / (radius * sqrt3));
		int x_coord;
		if (y_coord % 2 == 0) {
			x_coord = Math.round(x / (radius * 2));
		} else {
			x_coord = Math.round((x - radius) / (radius * 2));
		}
		Point p = new Point(x_coord, y_coord);
		return p;
	}
	
	public Point arrayToScreen(int x, int y) {
		int y_coord = Math.round(y * radius * sqrt3);
		int x_coord;
		if (y % 2 == 0) {
			x_coord = Math.round(x * (radius * 2));
		} else {
			x_coord = Math.round(x * (radius * 2)) + radius;
		}
		Point p = new Point(x_coord,y_coord);
		return p;
	}
	
	//step behavior (called on each frame)
	public void step() {
		Vector tempZones = new Vector(); //accumulate modZones so we can display properly
		for (int k = 0; k < regions.size(); k++) {
			modZones.clear();
			TriRegion tr = (TriRegion) regions.get(k);
			processRegion(tr); //create modzones in region
			processModZones(); //process modZones
			collapse(tr,false); //collapse zones
			//collapse(tr,true);
			tempZones.addAll(modZones);
		}
		modZones.clear(); //to prevent duplicate processing of last region
		super.step(); //to move holes only
		modZones = tempZones; //restore zones to provide proper display
	}
	
	/*for every point in the region, if it's perimeter, make it a modZone*/
	public void processRegion(TriRegion tr) {
		Point min = tr.r.minPt();
		Point max = tr.r.maxPt();
		for (int i = min.x; i < max.x; i += radius)
			for (int j = min.y; j < max.y; j += radius) {
				
				if (!tr.ptInside(i,j)) continue; //skip if not in triangle
				Point p = screenToArray(i,j);
				//remove existing mod zone
				ModZone mz = zoneAt(p);
				if (mz != null)
					modZones.remove(mz);
				//add a mod zone if we're on the perimeter
				if (isPerimeter(p) 
						&& (tr.fill ||
						isCorrectPerimeter(p,tr.collapseDir))
					) {
					mz = new ModZone();
					mz.center = p;
					mz.count = 0;
					mz.generate = tr.fill;
					modZones.add(mz);
				}
			}
	}
	
	//TODO: maybe allow slightly incorrect perimeters
	public boolean isCorrectPerimeter(Point p,int cDir) {
		return isVoid(move(p,shiftDir(cDir,3)));
	}
	
	public void collapse(TriRegion tr,boolean offset) {
		boolean collapsed = false;
		do
		{
			collapsed = false;
			//find column heads
			Vector v = new Vector();
			Point min = tr.r.minPt();
			Point max = tr.r.maxPt();
			for (int i = min.x; i < max.x; i += radius)
			for (int j = min.y; j < max.y; j += radius) {
				if (!tr.ptInside(i,j)) continue; //skip if not in triangle
				Point p = screenToArray(i,j);
				if (isPerimeter(p)) v.add(p);
			}
			
			//randomize list
			if (v.size() > 0)
			{
				Vector temp = new Vector();
				do
				{
					temp.add(v.remove(_r.nextInt(v.size())));
				}
				while(v.size() > 0);
				v = temp;
			}
			
			for (int i = 0; i < v.size(); i++)
			{
				Point p = (Point) v.get(i);
				if (isPerimeter(p))
				{
					//determine collapse direction
					int plane = 0,gravity = 0;
					gravity = tr.collapseDir;
					plane = shiftDir(gravity,2);
					if (offset) gravity = shiftDir(gravity,1);
					Point nA = move(p,plane);
					Point nB = move(p,shiftDir(plane,3));
					if (handleCollapse(tr,p,nA,gravity)) collapsed = true;
					else if (handleCollapse(tr,p,nB,gravity)) collapsed = true;
				}
			}
		} while(collapsed);
	}
	
	public boolean handleCollapse(TriRegion tr,Point src, Point nbr, int cDir)
	{
		if (!isVoid(nbr)) return false; //neighbouring column is at least as tall
		
		//don't collapse if it's a false column head
		if (!isVoid(move(src,shiftDir(cDir,3)))) return false;
		
		//don't collapse if it would break a single catom off of the mass
		for (int i = 1; i < 7; i++)
		{
			if (isLonely(move(src,i))) return false;
		}
		
		//traverse empty space to find head of column
		Point temp = nbr;
		int cnt;
		for (cnt = 1; cnt < 5; cnt++) //if depth is > 5, we definitely need to collapse
		{
			if (!isVoid(move(temp,cDir))) break;
			if (outOfBounds(move(temp,cDir))) break; //make sure we don't run off the edge
			temp = move(temp,cDir);
		}
		
		if (outOfBounds(temp)) return false;
		if (isFullyIsolated(temp)) return false;
		//if (!tr.ptInside(arrayToScreen(temp.x,temp.y))) return false;
		
		//collapse if slope too high
		//if (cnt > 1 + _r.nextInt(2)) //maybe maxSlope should only be 1?
		if (cnt > 1)
		{
			set(temp,FILLED);
			set(src,VOID);
			return true;
		}
		
		return false;
	}
	
	//create a TriRegion based on input triangle
	public void processRect() {
		TriRegion tr = new TriRegion();
		if (regionMode == 0)tr.r = getT(startPt,endPt).flipTriangle();
		else tr.r = getT(startPt,endPt);
		tr.collapseDir = getNormal(startPt,endPt);
		if (regionMode == 0) {
			tr.fill = false;
			regions.add(tr);
		} else if (regionMode == 1) {
			tr.fill = true;
			regions.add(tr);
		} else if (regionMode == 2) {
			Point min = tr.r.minPt();
			Point max = tr.r.maxPt();
			for (int i = min.x; i < max.x; i += radius)
				for (int j = min.y; j < max.y; j += radius) {
					if (!tr.ptInside(i,j)) continue; //skip if not in triangle
					Point p = screenToArray(i,j);
					if (outOfBounds(p)) continue;
					state[p.x][p.y] = FILLED;
					//remove any existing holes
					Hole h = holeAt(p);
					if (h != null) {
						for (int k = 0; k < 7; k++)
						{
							set(move(p,k),FILLED);
						}
						holes.remove(h);
					}
				}
			
			//create holes in filled area
			int area = (int)Math.round(tr.r.a.distance(tr.r.b) 
								* tr.r.b.distance(tr.r.c)*density);
			for (int i = 0; i < area; i++)
			{
				Point hc = new Point(min.x+_r.nextInt(max.x-min.x),
									 min.y+_r.nextInt(max.y-min.y));
				if (!tr.ptInside(hc)) continue;
				Hole h = makeHole(screenToArray(hc.x,hc.y));
				if (h != null)
					holes.add(h);
			}
		} else {}
		System.out.println(tr.toString());
	}

	public void printAllInfo(Point p) {
		if (outOfBounds(p)) {
			System.out.println("\tout of bounds.");
			return;
		}
		System.out.println("\tColor:" + state[p.x][p.y]);
		ModZone mz = zoneAt(p);
		if (mz != null) {
			System.out.println("\tmod zone. grow?" + mz.generate);
		}
	}
	
	public void paintOverlay(Graphics2D graph)
	{
		String mode = "";
		switch(regionMode) {
			case 0:
				graph.setColor(Color.RED);
				mode = "delete";
				break;
			case 1:
				graph.setColor(Color.GREEN);
				mode = "grow";
				break;
			case 2:
				graph.setColor(Color.BLUE);
				mode = "[fill]";
				break;
			default:
				graph.setColor(Color.BLUE);
				mode = "[clear]";
				break;
		}
		
		if(drawingRect) {
			Triangle t;
			if (regionMode == 0)t = getT(startPt,endPt).flipTriangle();
			else t = getT(startPt,endPt);
			Point mid = new Point((t.b.x+t.c.x)/2, (t.b.y+t.c.y)/2);
			graph.drawLine(t.a.x,t.a.y,t.b.x,t.b.y);
			graph.drawLine(t.b.x,t.b.y,t.c.x,t.c.y);
			graph.drawLine(t.a.x,t.a.y,t.c.x,t.c.y);
			graph.drawLine(t.a.x,t.a.y,mid.x,mid.y);
		}
		
		if (showRegions) {
			for (int i = 0; i < regions.size(); i++) {
				TriRegion tr = (TriRegion) regions.get(i);
				if (tr.fill) graph.setColor(Color.GREEN);
				else graph.setColor(Color.RED);
				graph.drawLine(tr.r.a.x,tr.r.a.y,tr.r.b.x,tr.r.b.y);
				graph.drawLine(tr.r.b.x,tr.r.b.y,tr.r.c.x,tr.r.c.y);
				graph.drawLine(tr.r.a.x,tr.r.a.y,tr.r.c.x,tr.r.c.y);
				//draw normal
				Point c = tr.r.ctr();
				drawNormalArrow(c,tr.collapseDir,graph);
			}
		}
		
		graph.setColor(Color.RED);
		graph.drawString(ticks + "---" + mode,0,10);
	}
	
	public void drawNormalArrow(Point ctr,int dir,Graphics2D graph) {
		//System.out.println(dir);
		double theta = (dir * 60) + 180; //degrees
		theta = Math.toRadians(theta);
		Point end = new Point();
		end.x = (int) Math.round(20*Math.cos(theta) + ctr.x);
		end.y = (int) Math.round(20*Math.sin(theta) + ctr.y);
		graph.drawLine(ctr.x,ctr.y,end.x,end.y);
	}
	
	/** Creates a new instance of HexView */
	public TriangleRegions(int x, int y) {
		super(x, y);
		regions = new Vector();
		
		Action clearAction = new AbstractAction() {
		    public void actionPerformed(ActionEvent e) {
		        System.out.println("resetting system");
		        init();
		        repaint();
		    }
		};
		
		Action infoAction = new AbstractAction() {
		    public void actionPerformed(ActionEvent e) {
		    	Point p = screenToArray(lastMouseX,lastMouseY);
		        System.out.println("info for:" + p.x + " " + p.y);
		        printAllInfo(p);
		    }
		};
		
		Action regionAction = new AbstractAction() {
		    public void actionPerformed(ActionEvent e) {
		    	showRegions = !showRegions;
		    	repaint();
		    }
		};
		
		Action modeAction = new AbstractAction() {
		    public void actionPerformed(ActionEvent e) {
		    	regionMode = (regionMode + 1) % 4;
		    	repaint();
		    }
		};
		
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke('i'),"print_info");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke('m'),"mode");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke('s'),"show");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("0"),"reset");
		this.getActionMap().put("reset",clearAction);
		this.getActionMap().put("show",regionAction);
		this.getActionMap().put("mode",modeAction);
		this.getActionMap().put("print_info",infoAction);
	}

	public void init() {
		super.init();
		regions = new Vector();
		
		for (int i = 0; i < maxX;i++)
			for (int j = 0; j < maxY; j++)
				state[i][j] = VOID;
		
		/*for (int i = 10; i < 90;i++)
			for (int j = 10; j < 90; j++)
					state[i][j] = FILLED;
		
		for (int i = 0; i < 600; i++) {
			Hole h = makeHole(new Point(_r.nextInt(maxX), _r.nextInt(maxY)));
			if (h != null)
				holes.add(h);
		}*/
	}
	
	
	//unit test
	public static void main(String[] args) {	
		TriangleRegions hb = new TriangleRegions(100, 100);
		hb.radius = 2;
		hb.setSize(410, 410);
		hb.saveFrames = true;
		hb.sleepTime = 1000;
		hb.mainLoop();
	}

	Vector regions;
	boolean showRegions = true;
	int regionMode = 0;
	float density = 0.001f;
}