/*
 * HexZones.java
 *
 */

import java.awt.*;
import java.awt.event.InputEvent;
import java.util.*;
//import javax.swing.*;

public class HexZones extends HexHoles{

	
	public static class ModZone {
		Point center;
		boolean generate;
		int count;
	};
	
	public ModZone zoneAt(Point p)
	{
		for(int i = 0; i < modZones.size(); i++)
		{
			ModZone mz = (ModZone)modZones.get(i);
			if ((mz.center.x == p.x) && (mz.center.y == p.y))
				return mz;
		}
		return null;
	}
	
	public Point tryToGen(Point p)
	{
		int dir = 1; 
		//System.out.print("Dir: "+ dir);
		//make sure there's not already a hole intersecting the area
		if (isHole(p)) return null; 
		if (isHole(move(p,shiftDir(dir,0)))) return null; 
		if (isHole(move(p,shiftDir(dir,1)))) return null; 
		if (isHole(move(p,shiftDir(dir,2)))) return null; 
		if (isHole(move(p,shiftDir(dir,3)))) return null; 
		if (isHole(move(p,shiftDir(dir,4)))) return null; 
		if (isHole(move(p,shiftDir(dir,5)))) return null; 
		if (isHole(move(p,dir,shiftDir(dir,-1)))) return null; 
		if (isHole(move(p,dir,dir))) return null;
		if (isHole(move(p,dir,shiftDir(dir,1)))) return null; 
		if (isHole(move(p,shiftDir(dir,1),shiftDir(dir,1)))) return null; 
		if (isHole(move(p,shiftDir(dir,1),shiftDir(dir,2)))) return null; 
		if (isHole(move(p,shiftDir(dir,2),shiftDir(dir,2)))) return null; 
		if (isHole(move(p,shiftDir(dir,2),shiftDir(dir,3)))) return null; 
		if (isHole(move(p,shiftDir(dir,3),shiftDir(dir,3)))) return null; 
		if (isHole(move(p,shiftDir(dir,3),shiftDir(dir,4)))) return null; 
		if (isHole(move(p,shiftDir(dir,4),shiftDir(dir,4)))) return null; 
		if (isHole(move(p,shiftDir(dir,4),shiftDir(dir,5)))) return null; 
		if (isHole(move(p,shiftDir(dir,5),shiftDir(dir,5)))) return null; 
		
		for (dir = 1; dir < 7; dir++)
		{
			int count = 0;
			if (!isEmpty(p)) count++; 
			if (!isEmpty(move(p,shiftDir(dir,0)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,1)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,2)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,3)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,4)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,5)))) count++;
			if (!isEmpty(move(p,dir,shiftDir(dir,-1)))) count++;
			if (!isEmpty(move(p,dir,dir))) count++;
			if (!isEmpty(move(p,dir,shiftDir(dir,1)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,1),shiftDir(dir,1)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,1),shiftDir(dir,2)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,2),shiftDir(dir,2)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,2),shiftDir(dir,3)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,3),shiftDir(dir,3)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,3),shiftDir(dir,4)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,4),shiftDir(dir,4)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,4),shiftDir(dir,5)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,5),shiftDir(dir,5)))) count++;
			//System.out.println("Count:" + count);
				if (count == 12) return generateHole(p,dir);
				if (count == 11) return generatePartialHole(p);
		}
		return null;
	}
	
	//generate a hole, then fill the area above it (except for one catom)
	//return new center for modzone
	public Point generatePartialHole(Point ctr)
	{
		int dir = 1;
		for (int i = 1; i < 7; i++)
		{
			if (isVoid(move(ctr,i,i,i)))
			{
				dir = i;
				break;
			}
		}
		//create and add hole
		Hole h = new Hole();
		h.center = ctr;
		h.dir = _r.nextInt(6) + 1;
		holes.add(h);
		set(ctr,HOLE);
		for (int i = 1; i < 7; i++)
			{
				set(move(ctr,i),HOLE);
				set(move(ctr,i,i),FILLED);
				set(move(ctr,i,shiftDir(i,-1)),FILLED);
			}
		set(move(ctr,dir,dir),VOID); //one hole left unfilled
		return move(ctr,dir,shiftDir(dir,1));
	}
	
	//generate a hole, then fill the area above it
	//return new center for modzone
	public Point generateHole(Point ctr,int dir)
	{
		//create and add hole
		Hole h = new Hole();
		h.center = ctr;
		h.dir = _r.nextInt(6) + 1;
		holes.add(h);
		set(ctr,HOLE);
		for (int i = 1; i < 7; i++)
			{
				set(move(ctr,i),HOLE);
				set(move(ctr,i,i),FILLED);
				set(move(ctr,i,shiftDir(i,-1)),FILLED);
			}
		return move(ctr,dir,shiftDir(dir,1));
	}
	
	//is there a hole that can be consumed by a modZone located at p?
	//if so, kill it and return new position of mode zone
	public Point holeToKill(ModZone mz)
	{
		Point ctr = mz.center;
		for (int dir = 1; dir < 7; dir++)
		{
			//offset the center from the modZone
			Point p = move(ctr,dir,shiftDir(dir,-1));
			//check for an empty hole + full "halo"
			int count = 0;
			if (isHole(p)) count++; 
			if (isHole(move(p,shiftDir(dir,0)))) count++;
			if (isHole(move(p,shiftDir(dir,1)))) count++;
			if (isHole(move(p,shiftDir(dir,2)))) count++;
			if (isHole(move(p,shiftDir(dir,3)))) count++;
			if (isHole(move(p,shiftDir(dir,4)))) count++;
			if (isHole(move(p,shiftDir(dir,5)))) count++;
			if (!isEmpty(move(p,dir,shiftDir(dir,-1)))) count++;
			if (!isEmpty(move(p,dir,dir))) count++;
			if (!isEmpty(move(p,dir,shiftDir(dir,1)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,1),shiftDir(dir,1)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,1),shiftDir(dir,2)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,2),shiftDir(dir,2)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,2),shiftDir(dir,3)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,3),shiftDir(dir,3)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,3),shiftDir(dir,4)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,4),shiftDir(dir,4)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,4),shiftDir(dir,5)))) count++;
			if (!isEmpty(move(p,shiftDir(dir,5),shiftDir(dir,5)))) count++;
			//System.out.print(count + " ");
			if ((count >= 18) && (_r.nextDouble() <= bindingPct(mz.center)))
			{
				//see if there's a hole at the center point
				for (int i = 0; i < holes.size(); i++)
				{
					Hole h = (Hole) holes.get(i);
					if ((h.center.x == p.x) && (h.center.y == p.y))
					{
						//set hole's direction to that needed by killHole
						h.dir = dir;
						if (count == 19) return killHole(mz,h);
						else return killPartial(mz,h);
					}
				}
			}
		}
		return null;
	}
	
	//remove a hole from the list, fill in the lattice points,
	// then return a new center for the modZone
	public Point killHole(ModZone mz, Hole h)
	{
		holes.remove(h);
		for (int i = 0; i < 7; i++) set(move(h.center,i),VOID);
		//----fill
		set(h.center,FILLED);
		set(move(h.center,h.dir),FILLED);
		set(move(h.center,shiftDir(h.dir,1)),FILLED);
		set(move(h.center,shiftDir(h.dir,-1)),FILLED);
		set(move(h.center,shiftDir(h.dir,-2)),FILLED);
		//-----empty
		set(mz.center,VOID);
		set(move(mz.center,shiftDir(h.dir,1)),VOID);
		set(move(mz.center,shiftDir(h.dir,-2)),VOID);
		set(move(mz.center,h.dir,shiftDir(h.dir,1)),VOID);
		set(move(mz.center,shiftDir(h.dir,-1),shiftDir(h.dir,-2)),VOID);
		return move(mz.center,h.dir,shiftDir(h.dir,-1));
	}
	
	public Point killPartial(ModZone mz, Hole h)
	{
		Point p = killHole(mz,h);
		set(move(mz.center,h.dir,h.dir),VOID);
		return p;
	}
	
	//initialization behavior (called on frame 0)
	public void init()
	{
		super.init();
		modZones = new Vector();
	}
	
	//step behavior (called on each frame)
	public void step()
	{
		super.step();
		processModZones();
	}
	
	public void processModZones() {
		//randomize modZones
		if (modZones.size() > 0)
		{
			Vector temp = new Vector();
			do
			{
				temp.add(modZones.remove(_r.nextInt(modZones.size())));
			}
			while(modZones.size() > 0);
			modZones = temp;
		}
		
		for (int i = 0; i < modZones.size(); i++)
		{
			ModZone mz = (ModZone)modZones.get(i);
			if (mz.generate) //generation zone
			{
				Point p = tryToGen(mz.center);
				if (p != null)
				{
					mz.center = p;
					mz.count--;
					if (mz.count <= 0)
					{
						modZones.remove(i);
						i--;
					}
				}
			}
			else //kill zone
			{
				Point p = holeToKill(mz);
				if (p !=null)
				{
					mz.center = p;
					mz.count--;
					if (mz.count <= 0)
					{
						modZones.remove(i);
						i--;
					}
				}
			}
		}
	}
	
	public void processRect()
	{
		super.processRect();
		int minX = Math.min(startPt.x,endPt.x) - radius;
		int minY = Math.min(startPt.y,endPt.y) - radius;
		int maxX = Math.max(startPt.x,endPt.x) + radius;
		int maxY = Math.max(startPt.y,endPt.y) + radius;
		//System.out.println(minX + " " + minY + " " + maxX + " "+ maxY);
		for (int i = minX; i < maxX; i+=radius)
			for (int j = minY; j < maxY; j+=radius)
			{
				int y_coord = (int)Math.floor((j*1.0)/(radius*sqrt3));
				int x_coord;
				if (y_coord%2==0)
				{
					x_coord = Math.round(i/(radius*2));
				}
				else
				{
					x_coord = Math.round((i-radius)/(radius*2));
				}
				Point p = new Point(x_coord,y_coord);
				
				//remove existing mod zone
				ModZone mz = zoneAt(p);
				if (mz!=null) modZones.remove(mz);
				
				if ((rectMods & InputEvent.SHIFT_MASK)!= 0)
				{
					if (isPerimeter(p))
					{
						mz = new ModZone();
						mz.center = p;
						mz.count = 0;
						mz.generate = false;
						modZones.add(mz);
					}
				}
				else if ((rectMods & InputEvent.ALT_MASK)!= 0)
				{
					if (isPerimeter(p))
					{
						mz = new ModZone();
						mz.center = p;
						mz.count = 0;
						mz.generate = true;
						modZones.add(mz);
					}
				}
				else
				{
					set(p,VOID);
					Hole h = holeAt(p);
					if (h!=null)holes.remove(h);
				}
			}
	}
	
	/** Creates a new instance of HexView */
	public HexZones(int x, int y) {
		super(x,y);
		distanceField = new int[maxX][maxY];
		for (int i = 0; i < maxX; i++)
			for (int j = 0; j < maxY; j++) {
				distanceField[i][j] = 0;
			}
		distanceMax = 0;
	}

	
	public void paintContent(java.awt.Graphics2D graph) {
		
		super.paintContent(graph);
		
		if (modZones == null) return;
		for (int i = 0; i < modZones.size(); i++)
		{
			ModZone mz = (ModZone) modZones.get(i);
			if (mz.generate) graph.setColor(colors[17]);
			else {graph.setColor(colors[12]);}
			int x1 = (mz.center.y%2==0)?(mz.center.x*2*radius):(mz.center.x*2*radius+radius) ;
			int y1 = Math.round(mz.center.y*radius*sqrt3);
			int dx = 2*radius;
			int dy = 2*radius;
			//draw circle
			graph.fillOval(x1,y1,dx,dy);
		}
	}
	
	
	//unit test
	public static void main(String[] args) {
		HexZones hb = new HexZones(100,100);
		hb.radius = 2; 
		hb.setSize(410, 410);
		hb.saveFrames = false;
		hb.sleepTime = 1000;
		hb.mainLoop();
	}
	
	//TODO: make falloff steeper
	public double bindingPct(Point p) {
		if (distanceMax == 0) return 1.0;
		double base = distanceField[p.x][p.y]/ (distanceMax * 1.0) + 0.1;
		if (base > 1.0) return 1.0;
		return base;
	}
	
	public Vector modZones;
	public int[][] distanceField;
	public int distanceMax;
}