/*
 * HexRegions.java
 *  
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

public class HexRegions extends HexZones {
	
	public class ModRegion {
		Rectangle bounds;
		boolean fill;
		int collapseDir;
	}
	
	boolean pointInRegion(ModRegion mr, Point p) {
		Point p2 = arrayToScreen(p.x,p.y);
		if ((p2.x >= mr.bounds.x) &&
			(p2.y >= mr.bounds.y) &&
			(p2.x <= mr.bounds.x + mr.bounds.width) &&
			(p2.y <= mr.bounds.y + mr.bounds.height))
			return true;
		return false;
	}
	
	//step behavior (called on each frame)
	public void step() {
		Vector tempZones = new Vector();
		for (int k = 0; k < regions.size(); k++) {
			modZones.clear();
			ModRegion mr = (ModRegion) regions.get(k);
			processRegion(mr); //create modzones in region
			processModZones(); //process modZones, update freq. count
			collapse(mr,false); //collapse zones
			collapse(mr,true);
			tempZones.addAll(modZones);
		}
		modZones.clear(); //to prevent duplicate processing of last region
		super.step(); //to move holes only
		modZones = tempZones; //restore zones to provide proper display
	}

	/*for every point in the region, if it's perimeter, make it a modZone*/
	public void processRegion(ModRegion mr) {
		for (int i = 0; i < mr.bounds.width; i += radius)
			for (int j = 0; j < mr.bounds.height; j += radius) {
					int y_coord = (int) Math.floor(((j + mr.bounds.y) * 1.0)
							/ (radius * sqrt3));
					int x_coord;
					if (y_coord % 2 == 0) {
						x_coord = Math.round((i + mr.bounds.x) / (radius * 2));
					} else {
						x_coord = Math.round(((i + mr.bounds.x) - radius)
								/ (radius * 2));
					}
					Point p = new Point(x_coord, y_coord);

					//remove existing mod zone
					ModZone mz = zoneAt(p);
					if (mz != null)
						modZones.remove(mz);

					if (mr.fill) {
						if (isPerimeter(p)) {
							mz = new ModZone();
							mz.center = p;
							mz.count = 0;
							mz.generate = true;
							modZones.add(mz);
						}
					} else {
						if (isPerimeter(p)) {
							mz = new ModZone();
							mz.center = p;
							mz.count = 0;
							mz.generate = false;
							modZones.add(mz);
						}
					}
			}
	}
	
	public void collapse(ModRegion mr,boolean offset) {
		//System.out.println(plane + " " + gravity);
		boolean collapsed = false;
		do
		{
			collapsed = false;
			//find column heads
			Vector v = new Vector();
			for (int i = mr.bounds.x; i < mr.bounds.x+mr.bounds.width; i += radius)
			for (int j = mr.bounds.y; j < mr.bounds.y+mr.bounds.height; j += radius) {
				Point p = screenToArray(i,j);
				if (isPerimeter(p)) v.add(p);
			}
			
			//randomize list
			if (v.size() > 0)
			{
				Vector temp = new Vector();
				do
				{
					temp.add(v.remove(_r.nextInt(v.size())));
				}
				while(v.size() > 0);
				v = temp;
			}
			
			for (int i = 0; i < v.size(); i++)
			{
				Point p = (Point) v.get(i);
				if (isPerimeter(p))
				{
					//determine collapse direction
					int plane = 0,gravity = 0;
					gravity = mr.collapseDir;
					//gravity = middleDir(p);  //comment this line out to re-enable manual gravity
					if (gravity == 0) continue;
					plane = shiftDir(gravity,2);
					if (offset) gravity = shiftDir(gravity,1);
					//System.out.print(gravity + " ");
					Point nA = move(p,plane);
					Point nB = move(p,shiftDir(plane,3));
					if (handleCollapse(mr,p,nA,gravity)) collapsed = true;
					else if (handleCollapse(mr,p,nB,gravity)) collapsed = true;
				}
			}
			//System.out.println("");
		} while(collapsed);
	}
	
	public boolean handleCollapse(ModRegion mr,Point src, Point nbr, int cDir)
	{
		if (!isVoid(nbr)) return false; //neighbouring column is at least as tall
		
		//don't collapse if it would break a single catom off of the mass
		for (int i = 1; i < 7; i++)
		{
			if (isLonely(move(src,i))) return false;
		}
		
		//traverse empty space to find head of column
		Point temp = nbr;
		int cnt;
		for (cnt = 1; cnt < 3; cnt++) //if depth is > 3, we definitely need to collapse
		{
			if (!isVoid(move(temp,cDir))) break;
			if (outOfBounds(move(temp,cDir))) break; //make sure we don't run off the edge
			temp = move(temp,cDir);
		}
		
		//System.out.println(cnt);
		
		if (outOfBounds(temp)) {return false;}
		if (isFullyIsolated(temp)) {return false;} //potentially required for dynamic normals
		//if (!pointInRegion(mr,temp)) {return false;} //ditto
		
		//collapse if slope too high
		if (cnt > 1 + _r.nextInt(2))
		{
			set(temp,FILLED);
			set(src,VOID);
			return true;
		}
		
		return false;
	}
	
	public Point screenToArray(int x,int y) {
		int y_coord = (int) Math.floor((y * 1.0) / (radius * sqrt3));
		int x_coord;
		if (y_coord % 2 == 0) {
			x_coord = Math.round(x / (radius * 2));
		} else {
			x_coord = Math.round((x - radius) / (radius * 2));
		}
		Point p = new Point(x_coord, y_coord);
		return p;
	}
	
	public Point arrayToScreen(int x, int y) {
		int y_coord = Math.round(y * radius * sqrt3);
		int x_coord;
		if (y % 2 == 0) {
			x_coord = Math.round(x * (radius * 2));
		} else {
			x_coord = Math.round(x * (radius * 2)) + radius;
		}
		Point p = new Point(x_coord,y_coord);
		return p;
	}
	
	public void processRect() {
		super.processRect();
		int minX = Math.min(startPt.x, endPt.x) - radius;
		int minY = Math.min(startPt.y, endPt.y) - radius;
		int maxX = Math.max(startPt.x, endPt.x) + radius;
		int maxY = Math.max(startPt.y, endPt.y) + radius;
		//System.out.println(minX + " " + minY + " " + maxX + " " + maxY);
		ModRegion mr = new ModRegion();
		mr.bounds = new Rectangle();
		mr.bounds.x = minX;
		mr.bounds.y = minY;
		mr.bounds.width = maxX - minX;
		mr.bounds.height = maxY - minY;
		if ((rectMods & InputEvent.SHIFT_MASK) != 0) {
			mr.fill = false;
			mr.collapseDir = lastKey;
			regions.add(mr);
		} else if ((rectMods & InputEvent.ALT_MASK) != 0) {
			mr.fill = true;
			mr.collapseDir = lastKey;
			regions.add(mr);
		} else //delete catoms, holes and modzones
		{
			for (int i = minX; i < maxX; i += radius)
				for (int j = minY; j < maxY; j += radius) {
					Point p = screenToArray(i, j);
					//remove existing mod zone
					ModZone mz = zoneAt(p);
					if (mz != null)
						modZones.remove(mz);
					set(p, VOID);
					Hole h = holeAt(p);
					if (h != null)
						holes.remove(h);
				}

		}
	}

	public void printAllInfo(Point p) {
		if (outOfBounds(p)) {
			System.out.println("\tout of bounds.");
			return;
		}
		System.out.println("\tColor:" + state[p.x][p.y]);
		ModZone mz = zoneAt(p);
		if (mz != null) {
			System.out.println("\tmod zone. grow?" + mz.generate);
		}
		System.out.print("\tsector scores: ");
		for (int i = 1; i < 7; i++) System.out.print(sectorScore(p,i) + " ");
		System.out.println("");
		System.out.println("\tnormal:" + middleDir(p));
	}
	
	public int middleDir(Point p) {
		int scores[] = new int[7];
		scores[0] = 0;
		for (int i = 1; i < 7; i++) scores[i] = sectorScore(p,i);
		
		//int total = 0;
		//for (int i = 0; i < 7; i++) total += scores[i];
		
		int filledSectors = 0;
		for (int i = 0; i < 7; i++) if (scores[i] > 5) filledSectors++;
		//System.out.println("fs:" + filledSectors);
		int firstEmpty = 0;
		for (int i = 1; i < 7; i++) {
			if (scores[i] == 0) {
				firstEmpty = i;
				break;
			}
		}
		//System.out.println("fe:" + firstEmpty);
		int currSectors = 0;
		for (int i = 1; i < 7; i++)
		{
			int currDir = shiftDir(firstEmpty,i);
			//System.out.print(currDir + " ");
			if (scores[currDir] > 5) currSectors++;
			if (currSectors >= filledSectors / 2) return currDir;
		}
		return 0;
	}
	
	public int sectorScore(Point p,int dir) {
		int score = 0;
		if (!isVoid(move(p,dir))) score++;
		
		if (!isVoid(move(p,dir,dir))) score++;
		if (!isVoid(move(p,dir,shiftDir(dir,1)))) score++;
		
		if (!isVoid(move(p,dir,dir,shiftDir(dir,1)))) score++;
		if (!isVoid(move(p,dir,dir,shiftDir(dir,-1)))) score++;
		if (!isVoid(move(p,dir,dir,dir))) score++;
		
		if (!isVoid(move(p,dir,dir,dir,shiftDir(dir,1)))) score++;
		if (!isVoid(move(p,dir,dir,dir,shiftDir(dir,-1)))) score++;
		if (!isVoid(move(p,dir,dir,shiftDir(dir,-1),shiftDir(dir,-1)))) score++;
		if (!isVoid(move(p,dir,dir,dir,dir))) score++;
		return score;
	}
	
	protected static int lastKey = 1;
	
	/** Creates a new instance of HexView */
	public HexRegions(int x, int y) {
		super(x, y);
		Action reportAction = new AbstractAction() {
		    public void actionPerformed(ActionEvent e) {
		        lastKey = Integer.parseInt(e.getActionCommand());
		        System.out.println(lastKey);
		    }
		};
		
		Action clearAction = new AbstractAction() {
		    public void actionPerformed(ActionEvent e) {
		        System.out.println("resetting system");
		        init();
		    }
		};
		
		Action infoAction = new AbstractAction() {
		    public void actionPerformed(ActionEvent e) {
		    	Point p = screenToArray(lastMouseX,lastMouseY);
		        System.out.println("info for:" + p.x + " " + p.y);
		        printAllInfo(p);
		    }
		};
		
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("1"),"key");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("2"),"key");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("3"),"key");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("4"),"key");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("5"),"key");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("6"),"key");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke('i'),"print_info");
		this.getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("0"),"reset");
		this.getActionMap().put("key",reportAction);
		this.getActionMap().put("reset",clearAction);
		this.getActionMap().put("print_info",infoAction);
	}

	public void init() {
		super.init();
		regions = new Vector();
		/*for (int i = 0; i < 10; i++)
			for (int j = 0; j < maxY; j++)
				state[i][j] = VOID;
		for (int i = 90; i < maxX; i++)
			for (int j = 0; j < maxY; j++)
				state[i][j] = VOID;
		for (int i = 0; i < maxX; i++)
			for (int j = 0; j < 10; j++)
				state[i][j] = VOID;
		for (int i = 0; i < maxX; i++)
			for (int j = 90; j < maxY; j++)
				state[i][j] = VOID;*/
		
		for (int i = 0; i < maxX;i++)
			for (int j = 0; j < maxY; j++)
				state[i][j] = VOID;
		/*
		for (int j = 10; j < maxY-10;j++)
		{
			switch(j%4)
			{
				case 0:
					for (int i = 10; i < maxX-8;i++) state[i][j] = FILLED;
					break;
				case 1:
					for (int i = 9; i < maxX-9;i++) state[i][j] = FILLED;
					break;
				case 2:
					for (int i = 9; i < maxX-9;i++) state[i][j] = FILLED;
					break;
				case 3:
					for (int i = 9; i < maxX-9;i++) state[i][j] = FILLED;
					break;
			}
		}*/
		for (int i = 10; i < 90;i++)
			for (int j = 10; j < 90; j++)
					state[i][j] = FILLED;
		
		for (int i = 0; i < 600; i++) {
			Hole h = makeHole(new Point(_r.nextInt(maxX), _r.nextInt(maxY)));
			if (h != null)
				holes.add(h);
		}
	}
	
	//unit test
	public static void main(String[] args) {
		HexRegions hb = new HexRegions(100, 100);
		hb.radius = 2;
		hb.setSize(410, 410);
		hb.saveFrames = false;
		hb.sleepTime = 1000;
		hb.mainLoop();
	}

	Vector regions;
}