/*
 * HexHoles.java
 *
 */

import java.awt.*;
import java.util.*;

public class HexHoles extends EvaluatingBackend {

	public Hole holeAt(Point p)
	{
		for(int i = 0; i < holes.size(); i++)
		{
			Hole h = (Hole)holes.get(i);
			if ((h.center.x == p.x) && (h.center.y == p.y))
				return h;
		}
		return null;
	}
	
	public boolean isHole(Point p)
	{
		if ((p.x < 0) || (p.y < 0) || (p.x >= maxX) || (p.y >= maxY)) return true;
		else return (state[p.x][p.y] == HOLE);
	}
	
	public boolean isEmpty(Point p){return super.isEmpty(p)||isHole(p);}

	
	/** is a Point p on the perimeter */
	public boolean isPerimeter(Point p)
	{
		if (isEmpty(p)) return false;
		for (int i = 1; i < 7; i++)
		{
			if (isProperVoid(move(p,i)))
			{
				return true;
			}
		}
		return false;
	}
	
	/**excludes singleton voids*/
	public boolean isProperVoid(Point p)
	{
		if (!isVoid(p)) return false;
		for (int i = 1; i < 7; i++)
		{
			if (isVoid(move(p,i)))
			{
				return true;
			}
		}
		return false;
	}
	
	/**are all 1-hop neighbors empty?*/
	public boolean isFullyIsolated(Point p)
	{
		for (int i = 1; i < 7; i++)
		{
			if (!isVoid(move(p,i)))
			{
				return false;
			}
		}
		return true;
	}
	/** is point filled, with only one neighbor*/
	public boolean isLonely(Point p)
	{
		if (isEmpty(p)) return false;
		
		int count = 0;
		for (int i = 1; i < 7; i++)
		{
			if (!isEmpty(move(p,i))) count++;
		}
		
		return (count <=1);
	}
	
	public static class Hole {
		Point center;
		int dir;
	};
	
	
	public Hole makeHole(Point p)
	{
		for (int i = 0; i < 7; i++) {if (isEmpty(move(p,i))) return null;}
		for (int i = 1; i < 7; i++) {if (isEmpty(move(move(p,i),i))) return null;}
		Hole h = new Hole();
		h.center = p;
		h.dir = _r.nextInt(6) +1;
		for (int i = 0; i < 7; i++) set(move(p,i),HOLE);
		return h;
	}
	
	//each row is a direction for a hole to move
	//each has 6 elements (the first 3 are turned into holes, 
	//the rest are filled back in)
	public static final int[][] moveArray = {{},
			{1,6,2,3,4,5},
			{2,1,3,4,5,6},
			{3,2,4,1,6,5},
			{4,3,5,2,1,6},
			{5,4,6,1,2,3},
			{6,5,1,2,3,4}};
	
	public boolean canMove(Hole h)
	{
		Point c = move(h.center,moveArray[h.dir][0]);
		Point l = move(h.center,moveArray[h.dir][1]);
		Point r = move(h.center,moveArray[h.dir][2]);
		//check if the 6 catom region extending in the direction
		//of movement of the hole is completely filled
		if (isEmpty(move(c,h.dir)) ||
				isEmpty(move(l,h.dir)) ||
				isEmpty(move(r,h.dir)) ||
				isEmpty(move(move(c,h.dir),h.dir)) ||
				isEmpty(move(move(l,h.dir),h.dir)) ||
				isEmpty(move(move(r,h.dir),h.dir))) return false;
		return true;
	}

	//move a Hole in the specified direction. Assumes canMove
	//already returned true.
	public void move(Hole h)
	{
		Point c = move(h.center,moveArray[h.dir][0]);
		Point l = move(h.center,moveArray[h.dir][1]);
		Point r = move(h.center,moveArray[h.dir][2]);
		set(move(c,h.dir),HOLE);
		set(move(l,h.dir),HOLE);
		set(move(r,h.dir),HOLE);
		set(move(h.center,moveArray[h.dir][3]),FILLED);
		set(move(h.center,moveArray[h.dir][4]),FILLED);
		set(move(h.center,moveArray[h.dir][5]),FILLED);
		h.center = c;
	}
	
	//initialization behavior (called on frame 0)
	public void init()
	{
		super.init();
		holes = new Vector();
		//set up initial holes
		/*for (int i = 0; i < 600; i++)
		{
			Hole h = makeHole(new Point(_r.nextInt(maxX),_r.nextInt(maxY)));
			if (h != null) holes.add(h);
		}*/
	}
	
	//step behavior (called on each frame)
	public void step()
	{
		if (holes.size() == 0) return;
		//randomize holes
		Vector temp = new Vector();
		do
		{
			temp.add(holes.remove(_r.nextInt(holes.size())));
		}
		while(holes.size() > 0);
		holes = temp;
		
		//move holes
		for (int i = 0; i < holes.size(); i++)
		{
			Hole h = (Hole)holes.get(i);
			if (canMove(h)) {move(h);} else {h.dir = _r.nextInt(6)+1;}
		}
		super.step();
	}
	
	
	public void processRect()
	{
		super.processRect();
	}
	
	/** Creates a new instance of HexHoles */
	public HexHoles(int x, int y) {
		super(x,y);
		holes = new Vector();
	}
	
	//unit test
	public static void main(String[] args) {
		HexHoles hb = new HexHoles(100,100);
		hb.radius = 2; 
		hb.setSize(410, 410);
		hb.saveFrames = false;
		hb.sleepTime = 1000;
		for (int i = 0; i < 600; i++)
		{
			Hole h = hb.makeHole(new Point(_r.nextInt(hb.maxX),_r.nextInt(hb.maxY)));
			if (h != null) hb.holes.add(h);
		}
		hb.mainLoop();
	}
	
	public Vector holes;
	public static final int HOLE = 1;
}