/*
 * HexBase.java
 *
 */

/* Need to override: init(),step(),paintContent(),processRect(),main() */

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import java.awt.event.*;
import javax.swing.*;

public class HexBase extends JComponent {

	public Point move(Point p, int d)
	{
		switch (d)
		{
			case 0:
				return p;
			case 1:
				if (p.y % 2 == 0)
					return new Point(p.x-1,p.y-1);
					else return new Point(p.x,p.y-1);
			case 2:
				if (p.y % 2 == 0)
					return new Point(p.x,p.y-1);
					else return new Point(p.x+1,p.y-1);
			case 6:
				return new Point (p.x-1,p.y);
			case 3:
				return new Point (p.x+1,p.y);
			case 5:
				if (p.y % 2 == 0)
					return new Point(p.x-1,p.y+1);
					else return new Point(p.x,p.y+1);
			case 4:
				if (p.y % 2 == 0)
					return new Point(p.x,p.y+1);
					else return new Point(p.x+1,p.y+1);
			default:
				System.out.println("Unknown direction");
				return p;
		}
	}

	public Point move(Point p, int d1, int d2) {return move(move(p,d1),d2);}
	
	public Point move(Point p, int d1, int d2,int d3) {return move(move(move(p,d1),d2),d3);}
	
	public Point move(Point p, int d1, int d2,int d3, int d4) 
		{return move(move(move(move(p,d1),d2),d3),d4);}
	
	public boolean isEmpty(Point p)
	{
		return isVoid(p);
	}
	
	public boolean isVoid(Point p)
	{
		if ((p.x < 0) || (p.y < 0) || (p.x >= maxX) || (p.y >= maxY)) return true;
		else return (state[p.x][p.y] == VOID);
	}
	
	public void set(Point p, int v)
	{
		//System.out.println(p.x + " " + p.y + " " + v);
		if ((p.x < 0) || (p.y < 0) || (p.x >= maxX) || (p.y >= maxY)) return;
		else state[p.x][p.y] = v;
	}
	
	public boolean outOfBounds(Point p)
	{
		if ((p.x < 0) || (p.y < 0) || (p.x >= maxX) || (p.y >= maxY)) return true;
		return false;
	}
	
	public int shiftDir(int d, int s)
	{
		if (d == 0) return 0;
		d = d-1;
		d = (d+12+s)%6 + 1;
		return d;
	}
	
	//initialization behavior (called on frame 0)
	public void init()
	{
		ticks = 0;
	}
	
	//step behavior (called on each frame)
	public void step()
	{
		
	}
	
	//mouse click behavior
	/*public void click(int x, int y, boolean shift, boolean cmd)
	{
		System.out.println(x + " " + y);
	}*/
	
	/** Creates a new instance of HexView */
	public HexBase(int x, int y) {
		initColors();
		radius = 20; //default radius
		state = new int[x][y];
		maxX = x; maxY = y;
		//set up int array
		for (int i = 0; i < x; i++)
			for (int j = 0; j < y; j++)
			{
				state[i][j] = FILLED;
			}
	}

	protected static float sqrt3 = (float)Math.sqrt(3.0);
	
	public void paint(Graphics g) {paint((Graphics2D)g);}
	
	public void paint(java.awt.Graphics2D graph) {
		paintContent(graph);
		paintOverlay(graph);
	}
	
	public void paintContent(Graphics2D graph)
	{
		graph.setColor(Color.BLACK);
		graph.fillRect(0, 0, this.getWidth(), this.getHeight());
		for (int i = 0; i < maxX; i++)
			for (int j = 0; j < maxY; j++) {
					graph.setColor(colors[state[i][j]]);
					int x1 = (j%2==0)?(i*2*radius):(i*2*radius+radius) ;
					int y1 = Math.round(j*radius*sqrt3);
					int dx = 2*radius;
					int dy = 2*radius;
					//draw circle
					graph.fillOval(x1,y1,dx,dy);
				}
	}
	
	public void paintOverlay(Graphics2D graph)
	{
		if(drawingRect)
		{
			if ((rectMods & InputEvent.SHIFT_MASK)!= 0)
			{
				graph.setColor(Color.RED);
			}
			else if ((rectMods & InputEvent.ALT_MASK)!= 0)
			{
				graph.setColor(Color.GREEN);
			}
			else
			{
				graph.setColor(Color.BLUE);
			}	
			
			Point tl = new Point();
			tl.x = Math.min(startPt.x,endPt.x);
			tl.y = Math.min(startPt.y,endPt.y);
			int xDist = Math.abs(endPt.x-startPt.x);
			int yDist = Math.abs(endPt.y-startPt.y);
			graph.drawRect(tl.x,tl.y,xDist,yDist);
		}
		
		graph.setColor(Color.RED);
		graph.drawString(ticks + "",0,10);
	}

	private void initColors() {
		colors = new Color[33];
		colors[0] = new Color(0,0,0); //black
		colors[1] = new Color(0, 0, 0); //black
		colors[2] = new Color(191, 191, 191); //grey75
		colors[3] = new Color(127, 127, 127); //grey50
		colors[4] = new Color(171, 130, 255); //lavender
		colors[5] = new Color(85, 26, 139); //purple4
		colors[6] = new Color(125, 38, 205); //purple3
		colors[7] = new Color(145, 44, 238); //purple2
		colors[8] = new Color(155, 48, 255); //purple1
		colors[9] = new Color(0, 0, 139); //blue 4
		colors[10] = new Color(0, 0, 205); //blue3
		colors[11] = new Color(0, 0, 238); //blue2
		colors[12] = new Color(0, 0, 255); //blue2
		colors[13] = new Color(0, 100, 0); //DarkGreen
		colors[14] = new Color(0, 139, 0); //green4
		colors[15] = new Color(0, 205, 0); //green3
		colors[16] = new Color(0, 238, 0); //green2
		colors[17] = new Color(0, 255, 0); //green1
		colors[18] = new Color(139, 101, 8); //DarkGoldenrod4
		colors[19] = new Color(139, 139, 0); //yellow4
		colors[20] = new Color(205, 205, 0); //yellow3
		colors[21] = new Color(238, 238, 0); //yellow2
		colors[22] = new Color(255, 255, 0); //yellow1
		colors[23] = new Color(139, 90, 0); //orange4
		colors[24] = new Color(205, 133, 0); //orange3
		colors[25] = new Color(238, 154, 0); //orange2
		colors[26] = new Color(255, 165, 0); //orange1
		colors[27] = new Color(139, 35, 35); //brown 4
		colors[28] = new Color(139, 0, 0); //red4
		colors[29] = new Color(205, 0, 0); //red3
		colors[30] = new Color(238, 0, 0); //red2
		colors[31] = new Color(255, 0, 0); //red1
	}
	
	public void processRect()
	{
		System.out.println("("+startPt.x+","+startPt.y+")--("+endPt.x+","+endPt.y+")  "+rectMods);
		
	}
	
	public void mainLoop()
	{
		//set up GUI
		JFrame f = new JFrame();
		f.getContentPane().add(this);
		f.setSize(this.getPreferredSize());
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setVisible(true);
		
		addMouseListener(new MouseAdapter() {
			public void mouseEntered(MouseEvent me) 
			{System.out.println("p");
			paused = true;};
			public void mouseExited(MouseEvent me) 
			{System.out.println("u");
			paused = false;
			if (drawingRect)
			{
				drawingRect = false;
				repaint();
			}};
			public void mousePressed(MouseEvent me) 
			{drawingRect = true;
			rectMods = me.getModifiers();
			startPt=endPt=me.getPoint();};
			public void mouseReleased(MouseEvent me) 
			{
				if (drawingRect)
					{
						drawingRect = false;
						processRect();
						repaint();
					}};
		});
		
		this.addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent me) 
			{if(drawingRect)
				{endPt = me.getPoint();
				repaint();}
			};
			public void mouseMoved(MouseEvent me) {
				lastMouseX = me.getX();
				lastMouseY = me.getY();
			};
		});
		
		ticks = 0;
		init();
		while(true)
		{	
			while (!paused)
			{
				step();
				repaint();
				if (saveFrames)
				{
					BufferedImage image = new BufferedImage(getWidth(), getHeight(),
					            BufferedImage.TYPE_INT_RGB);
					Graphics2D g2 = image.createGraphics();
					paint(g2);
				    g2.dispose();
				    try
					{
				    		String fname;
				    		if (ticks < 10)
				    			fname = new String("image000" + ticks + ".png");
				    		else if (ticks < 100)
				    			fname = new String("image00" + ticks + ".png");
				    		else if (ticks < 1000)
				    			fname = new String("image0" + ticks + ".png");
				         else 
				         	fname = new String("image" + ticks + ".png");
				         
				    		ImageIO.write(image, "png", new File(fname));
					}
				    catch(IOException e)
					{
				    	System.out.println("Error saving file");
					}
				}
				try
				{
					Thread.sleep(sleepTime);
				}
				catch (Exception e)
				{
					System.out.println("Sleep interrupted!");
				}
				ticks++;
			}
		}
	}
	
	//unit test
	public static void main(String[] args) {
		//set up GUI
		HexBase hb = new HexBase(10,10);
		hb.radius = 2; 
		hb.setSize(400, 400);
		hb.saveFrames = false;
		hb.sleepTime = 1000;
		hb.mainLoop();
	}
	
	public int[][] state; //catom values
	public int maxX,maxY;
	public Color[] colors;
	public int radius;
	public int ticks;
	
	protected static java.util.Random _r = new java.util.Random();
	
	public boolean saveFrames = false;//saving to file
	public int sleepTime = 1000;
	protected boolean paused = false;
	
	//rectangle drawing
	protected boolean drawingRect = false;
	protected Point startPt,endPt;
	protected int rectMods;
	
	//mouse position
	protected int lastMouseX;
	protected int lastMouseY;
	
	//color names
	public static final int VOID = 0;
	public static final int FILLED = 4;
}