import javax.swing.JFrame;
import java.util.Vector;
import java.text.*;
/*
 * Created on Mar 28, 2005
 *
 * Provides optional non-interactive backend with statistics gathering
 */

/**
 * @author mdr
 *
 */
public class EvaluatingBackend extends HexBase {

	public EvaluatingBackend(int x, int y) {
		super(x,y);
	}
	
	/**override with meaningful objective (0.0-1.0)*/
	public float objectiveFcn() {
		return 0.0f;
	}
	
	public void mainLoop()
	{
		if (interactive)
		{
			super.mainLoop();
			return;
		}
		//set up GUI
		JFrame f = new JFrame();
		f.getContentPane().add(this);
		f.setSize(this.getPreferredSize());
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setVisible(true);
		
		Vector v = new Vector();
		
		NumberFormat format = new DecimalFormat("0.000");
		
		System.out.println(numRuns + " runs, " + numFrames + " timesteps, reporting every " 
							+ reportEvery + " frames.");
		
		for (int j = 0; j < numRuns; j++)
		{
			ticks = 0;
			init();
			repaint();
			int k = 0;
			for (int i = 0; i < numFrames; i++)
			{	
					step();
					ticks++;
					if (ticks % reportEvery == 0)
					{
						float obj = objectiveFcn();
						System.out.print(format.format(obj) + " ");
						repaint();
						if (j == 0)
						{
							v.add(new Float(obj));
						}
						else
						{
							float cur = ((Float)v.get(k)).floatValue();
							cur += obj;
							v.setElementAt(new Float(cur),k);
						}
						k++;
					}
			}
			System.out.println("");
		}
		
		System.out.println("avg: ");
		for (int i = 0; i < v.size(); i++)
		{
			float fv = ((Float)v.get(i)).floatValue() / numRuns;
			System.out.print(format.format(fv) + " ");
		}
		System.out.println("");
	}
	
	boolean interactive = true;
	int numFrames = 500;
	int reportEvery = 100;
	int numRuns = 10;
}
