// Spatial Index Library
//
// Copyright (C) 2003 Navel Ltd.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Contact information:
//  Mailing address:
//    Marios Hadjieleftheriou
//    University of California, Riverside
//    Department of Computer Science
//    Surge Building, Room 310
//    Riverside, CA 92521
//
//  Email:
//    marioh@cs.ucr.edu

#ifndef __spatialindex_mvrtree_leaf_h
#define __spatialindex_mvrtree_leaf_h

namespace SpatialIndex
{
	namespace MVRTree
	{
		class Leaf : public Node
		{
		public:
			virtual ~Leaf();

		private:
			Leaf(MVRTree* pTree, long id);

			virtual NodePtr chooseSubtree(const TimeRegion& mbr, unsigned long level, std::stack<long>& pathBuffer);
			virtual NodePtr findLeaf(const TimeRegion& mbr, long id, std::stack<long>& pathBuffer);

			virtual void split(
				unsigned long dataLength, byte* pData, TimeRegion& mbr, long id, NodePtr& left, NodePtr& right,
				TimeRegion& mbr2, long id2, bool bInsertMbr2 = false);

			friend class MVRTree;
			friend class Node;
		}; // Leaf
	}
}

#endif /*__spatialindex_mvrtree_leaf_h*/
