#!/usr/bin/perl

#
# usage: ./make_docs.pl
#

##################
# Global Variables

my @filelist = ("CatomCode.cxx","Catom.cxx","Catom.hxx","CatomSim.cxx","CatomSim.hxx","CatomWorld.cxx","CatomWorld.hxx","CodeModuleList.hxx","CodeModule.cxx","CodeModule.hxx","DPRSim.cxx","FeatureMap.cxx","FeatureMap.hxx","GlobalConstants.hxx","Network.cxx","Network.hxx","Primitives.cxx","Primitives.hxx","SmartYield.cxx","SmartYield.hxx");

my @modulelist = ("XYMelt.cxx","XYMelt.hxx","Hierarchy.cxx","Hierarchy.hxx","Flicker.cxx","Flicker.hxx","RemoteFeatureTest.cxx","RemoteFeatureTest.hxx","Sculpture.cxx","Sculpture.hxx","TestAggregation.cxx","TestAggregation.hxx","TestMessaging.cxx","TestMessaging.hxx");

#########################################
# Set up the directories and helper files

system("rm -rf webdocs; mkdir webdocs; cp utils/makedocs/SyntaxHighlighter.css webdocs/; cp utils/makedocs/shBrushCSharp.js webdocs/; cp utils/makedocs/shCore.js webdocs/");

#####################
# Create the webpages

my $file;
my $newfile;
system("cp utils/makedocs/menu_header.html webdocs/menu.html");
system("cp utils/makedocs/index.html webdocs/index.html");

foreach $file (@filelist) {

    $newfile = $file;
    $newfile =~ s/.cxx/_cxx/;
    $newfile =~ s/.hxx/_hxx/;
    $newfile = $newfile . ".html";
   
    print("Creating: $newfile\n");

    system("cp utils/makedocs/header.html webdocs/$newfile");
    system("cat $file >> webdocs/$newfile");
    system("cat utils/makedocs/footer.html >> webdocs/$newfile");
    system("perl -pi -e s/FILENAME/\"$file\"/g webdocs/$newfile");

    system("echo '<a target=\"content\" href=\"$newfile\">$file</a><br>\n' >> webdocs/menu.html");
}

system("echo '<BR><BR><H3>Code Modules</H3><BR>\n' >> webdocs/menu.html");

foreach $file (@modulelist) {

    $newfile = $file;
    $newfile =~ s/.cxx/_cxx/;
    $newfile =~ s/.hxx/_hxx/;
    $newfile = $newfile . ".html";
   
    print("Creating: $newfile\n");

    system("cp utils/makedocs/header.html webdocs/$newfile");
    system("cat CodeModules/$file >> webdocs/$newfile");
    system("cat utils/makedocs/footer.html >> webdocs/$newfile");
    system("perl -pi -e s/FILENAME/\"$file\"/g webdocs/$newfile");

    system("echo '<a target=\"content\" href=\"$newfile\">$file</a><br>\n' >> webdocs/menu.html");
}

system("cat utils/makedocs/menu_footer.html >> webdocs/menu.html");
