#include <stdlib.h>
#include <string>
#include <stdarg.h>
#include <iostream>
#include <iomanip>

#include "CatomWorld.hxx"
#include "LatticeFunctions.hxx"
#include "Modeler.hxx"

#include <ode/config.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <GL/glx.h>
#include <ode/ode.h>
#include "graphics/graphics.h"
#include "graphics/internal.h"


#ifndef WORLDBUILDER_H
#define WORLDBUILDER_H


class WorldBuilder {
public:
  WorldBuilder();
  ~WorldBuilder();

  void setWorld(CatomWorld* wp);
  void setLattice(string l);
  void setMode(int i);
  void setScrollMode(int m);
  void setColor(int r, int g, int b);
  void setFillStyle(bool solid);

  void saveWorldAs(string filename);

  void updateBuilder();

  void import(string filename, int size, float precision, bool flipYZ, bool atCursor);
  void requestGUIDChange(long unsigned int newg);
  void clearAll();

  bool mouseMoved(int x, int y);
  bool buttonPressed(unsigned int button, int x, int y);
  bool handleKeyPress(KeySym key, bool ctrl);

private:

  struct color{
    int r;
    int g;
    int b;
  } catomColor;

  
  struct primitiveRequest{
    bool done;
    string type;
    float* params;
    bool atCursor;
  } primReq;

  struct modelRequest{
    bool done;
    string filename;
    int size;
    float precision;
    bool solid;
    bool flipYZ;
    bool atCursor;
  } modelReq;

  CatomWorld* worldPtr;
  
  string lattice;

  unsigned long int GUID;
  unsigned long int newGUID;
  bool GUIDChangeReq;
  
  bool clearReq;

  Point3D *cursor;
  int cx;
  int cy;
  float cz;
  int mode;
  int scrollmode;
  bool legalcursor;
  bool fillSolid;

  void moveCursor();
};

#endif
