#ifndef __WP_MANAGER__
#define __WP_MANAGER__
#include <map>
#include <deque>
#include "wp_parse.hxx"
#include "CatomWorld.hxx"

using namespace std;

extern CatomWorld *worldPtr;

class WPManager {
public:
	unsigned long steps;
	Watchpoint *wp_master;
	set<string> wpNames;
	int max_temporal; //max future temporal extent
	map<string,int> minExtent;
	map<string,int> maxExtent;
	map<string,map<CatomSim *,deque<int> > > savedState; //to access catom x's var foo (current value) savedState["foo"][x][0]
	map<catomID,deque<int> > fullState;
	
	WPManager(string input);
	~WPManager();
	void step();
	int getState(CatomSim *c,string name);
	set<CatomSim*> possibleNeighbors(Watchpoint *wp,map<CatomSim*,set <CatomSim *> > &n);
	int lookupSavedState(CatomSim *c,string varName,int offset);
	void addLinesForWatchpoint(Watchpoint *wp);
};

#endif //__WP_MANAGER__
