#include "StateFile.hxx"
#include <iostream>
#include <string>

using namespace std;

int
main( int argc, char **argv )
{
  StateFile::File myFile;
  StateFile::Module *myModule = new StateFile::Module( 1, 5 );
  uint32 catoms, catomid;
  int minX, maxX, minY, maxY, minZ, maxZ;
  std::string *name;

  if (argc != 2) {
    cout << "Need one " << ((argc>2) ? "(and only one)" : "") << "argument" << endl;
    exit(1);
  }

  catoms=catomid=0;
  maxX=maxY=maxZ=0;
  minX=minY=minZ=255;

  name = new std::string("_sim");

  myModule->setName( name );

  std::cout << "Filename " << argv[0] << endl;

  myFile.fileOpen( argv[1] );

  myFile.registerModule( myModule );

  myFile.fileRead_ModuleHeader();

  catomid = myFile.fileRead_Content();

  while( catomid > 0 ) {
    catoms++;
    
    StateFile::ByteData32 *bd32 = myModule->getContent();

    if (bd32 == NULL)
      catomid = 0;
    else
      {
	uint8* ptr = bd32->getData();

	if (ptr[0] > maxX)
	  maxX = ptr[0];
	if (ptr[1] > maxY)
	  maxY = ptr[1];
	if (ptr[2] > maxZ)
	  maxZ = ptr[2];
	
	if (ptr[0] < minX)
	  minX = ptr[0];
	if (ptr[1] < minY)
	  minY = ptr[1];
	if (ptr[2] < minZ)
	  minZ = ptr[2];
	
	catomid = myFile.fileRead_Content();
      }
  }

  myFile.fileClose();

  cout << "From " << catoms << " Catoms: " << endl
       << "MaxX: " << maxX << endl
       << "MinX: " << minX << endl
       << "MaxY: " << maxY << endl
       << "MinY: " << minY << endl
       << "MaxZ: " << maxZ << endl
       << "MinZ: " << minZ << endl;

  delete myModule;

  return 0;
}
