#ifndef __STATEFILE_STATEFILE_H
#define __STATEFILE_STATEFILE_H

#include <string>
#include <memory.h>
#include "stdlib.h"
#include <vector>
#include <assert.h>

#include <netinet/in.h>

#include "BasicTypes.hxx"
#include "FileFormat.hxx"
#include "Modules.hxx"

#define STATEFILE_DEBUG (false)

namespace StateFile {

  class File {
    
  private:  
    
    std::fstream *stream_;

    uint8 version_;
    char *filename_;
    
    bool write8( const uint8 *in );
    bool write32( const uint32 *in );
    uint8 read8( void );
    uint32 read32( void );

    std::vector<Module*>::iterator mIter_;

    Module* getModule( void );

    bool fileOpenRead();
    bool fileOpenWrite();

    void moduleReport( void );
  public:
    
    std::vector<Module*> inModules_;
    std::vector<Module*> outModules_;
    
    File( void );
    
    bool fileOpen( char *filename, bool write=false );
    void fileClose( void );

    void registerModule( Module* m );

    // READ
    bool fileRead_ModuleHeader();
    uint32 fileRead_Content();
    
    // WRITE
    bool fileWrite_ModuleHeader();
    bool fileWrite_BodyStart();
    bool fileWrite_Content( uint32 id );
  };

} // namespace

#endif /* __STATEFILE_STATEFILE_H */
