#ifndef __STATEFILE_BYTELIST_H
#define __STATEFILE_BYTELIST_H

#include "BasicTypes.hxx"
#include <string>
#include <fstream>

namespace StateFile {

class ByteData;
class ByteData32;
class ByteData8;

class ByteData {
protected:
  uint32  len_;
  uint8*  data_;

  uint8   byteLen_;
  uint32  mask_;

  uint32  localMem_;

  void setSize( uint32 size ) {
    len_ = size & mask_;
  }

public:

  ByteData( void );
  ~ByteData(void);


  // -- GET
  uint32 getSize( void ) { return len_; }

  uint32 byteLength( void );

  uint8* getData( void );
  uint8  getData( uint32 index );

  std::string toString( void );


  // -- SET
  void setData( uint8* data, uint32 size );
  void setData( std::string data );

  void setLength( uint32 size );
  void clear( void );


  // -- FILES
  bool fileRead( std::fstream *file, bool skip=false );
  bool fileWrite( std::fstream *file, bool skip=false );

};

class ByteData32 : public ByteData {
public:
  ByteData32() : ByteData() { 
    byteLen_ = 4; 
    mask_ = 0xffffffff;
  }

};

class ByteData8 : public ByteData {
public:
  ByteData8() : ByteData() { 
    byteLen_ = 1; 
    mask_ = 0xff; 
  }

};

} /* namespace */

#endif /* __STATEFILE_BYTELIST_H */
