
#ifndef BASICTYPES_INCLUDED
#define BASICTYPES_INCLUDED

#define LINUX 1

#include <string>

namespace StateFile {
  struct eqstring {
    bool operator()(const std::string *ul1, const std::string *ul2) const {
      return !(ul1->compare(ul2->c_str()));
    }
  };
}




#if defined( WIN32 ) && !defined( __GNUWIN32__ )

     typedef signed __int8            int8;
     typedef unsigned __int8          uint8;
     typedef signed __int16           int16;
     typedef unsigned __int16         uint16;
     typedef signed long              int32;
     // qt has trouble with the following
     // QString( "%1" ).arg( (uint32)... )
     // if we define uint32 this was
     // typedef unsigned __int32     uint32;
        // so we use this
     typedef unsigned long            uint32;
     typedef signed __int64           int64;
     typedef unsigned __int64         uint64;
     typedef char                     mybyte;
     typedef unsigned char            myubyte;

#   define socklen_t SOCKET_SIZE_TYPE

#elif defined( LINUX ) || defined( __GNUWIN32__ )
//     typedef signed char               int8;
     typedef char               int8;
     typedef unsigned char             uint8;
     typedef signed short              int16;
     typedef unsigned short            uint16;
     typedef signed int                int32;
     typedef unsigned int              uint32;
     typedef signed long long          int64;
     typedef unsigned long long        uint64;
     typedef char                      mybyte;
     typedef unsigned char             myubyte;
#else
#  error undefined platform
#endif

#endif // #ifndef BASICTYPES_INCLUDED
