///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __GLOBALCONSTANTS_HXX
#define __GLOBALCONSTANTS_HXX

// Simulator Debug Levels
#define DPR_DEBUG (false)
#define DPR_API_DEBUG (false)
#define DPR_MESSAGE_DEBUG (false)
#define DPR_NETWORK_DEBUG (false)
#define DPR_CATOMCODE_DEBUG (false)
#define DPR_PARSER_DEBUG (false)
#define DPR_FEATUREMAP_DEBUG (false)
#define DPR_THREADING_DEBUG (false)
#define DPR_BUILDER_DEBUG (false)

// Global simulation fidelity knob
#define GRAVITY 9.82
#define FRICTION 0.01
#define EPSILON 0.1

// Catom Constants
#define CATOM_MASS 1
#define CATOM_RADIUS 1.000

// Generic feature map # of features
#define LATTICE_TYPE (CatomWorld::lattice_type)
#define NUM_FEATURES (CatomWorld::num_features)
#define NUM_NEIGHBORS (CatomWorld::num_neighbors)

#define GENERIC_BUFFER_SIZE 10
#define MAX_NUM_DIGITS 10
#define NUM_DIGITS 7

#endif  /* __GLOBALCONSTANTS_HXX */
