#ifndef __FEATURE_MAP_ITERATOR_H
#define __FEATURE_MAP_ITERATOR_H

#include "FeatureMap.hxx"
#include <assert.h>

bool FeatureAll( Feature* f);
bool FeatureIsEmpty( Feature* f );
bool FeatureIsOccupied( Feature* f );

class FeatureMapIterator {
private:
  Feature *base_;
  featureID index_;
  bool (*predicate_)( Feature *f );

  void nextValid( void );

public:

  FeatureMapIterator( Feature *base, bool (*predicate)( Feature *f ) );
  ~FeatureMapIterator();

  bool operator!() const;
  void* operator()() const;
  void operator++();

  featureID which(void);
  void reset(void);
};

#endif /* __FEATURE_MAP_ITERATOR_H */
