#include "FeatureMapIterator.hxx"
#include "CatomWorld.hxx"

extern CatomWorld *worldPtr;


bool FeatureAll( Feature* f ) {
  assert(f);
  return true;
}

bool FeatureIsEmpty( Feature* f ) { 
  assert(f); 
  return (f->getRemoteFeature()==NULL); 
}

bool FeatureIsOccupied( Feature* f ) { 
  assert(f); 
  return (f->getRemoteFeature()!=NULL); 
}

FeatureMapIterator::FeatureMapIterator( Feature *base, bool (*predicate)( Feature *f ) )  : base_( base ), index_( 0 ), predicate_( predicate ) {
  assert( base != NULL );

  nextValid();   // 0 is not a feature.
}

FeatureMapIterator::~FeatureMapIterator(void) {}

void FeatureMapIterator::nextValid( void ) {
  while( ++index_ < NUM_FEATURES+1 ) 
    if ( predicate_( &(base_[index_]) ) )
      return;
}

bool FeatureMapIterator::operator!() const {
  return ( index_ < NUM_FEATURES+1 );
}

void* FeatureMapIterator::operator()() const { 
  if ( index_ < NUM_FEATURES+1 )
    return &(base_[index_]); 
  return NULL;
}

void FeatureMapIterator::operator++() { nextValid(); }

featureID FeatureMapIterator::which( void ) { return index_; }

void FeatureMapIterator::reset( void ) { index_ = 0; }
