#ifndef __DPRSim_hxx__
#define __DPRSim_hxx__

#include "CatomWorld.hxx"

typedef struct {
    void (*preStart)();
    void (*threadStart)();
    void (*start)();
    void (*tick)();
    void (*end)();
    void (*getView)(float xyz[3], float hpr[3], void *rgb);
} SimCallback;

extern CatomWorld *worldPtr;
void selectCallback(float x, float y, float z, float dx, float dy, float dz);
void simStop();
extern "C" {
	void simPause(bool state);
	bool simGetPaused();
}
bool building();
void simAdvanceSteps(int n);

// Extern of Catom Function for non-Threaded execution
extern void *catomFunction(void *vargp);


#endif /* __DPRSim_hxx__ */
