///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TESTMESSAGING_H
#define __TESTMESSAGING_H

class Catom;
class Message;

#include "CodeModule.hxx"

#include "Network.hxx"

CODE_MODULE_PROTOTYPE( TestMessaging, TestMessaging );
extern MailboxID testMessagingBox;

class ExampleMessage : public Message {
protected:
  int payload;

public:
  ExampleMessage(MailboxID mailboxName, int dataValue) : 
    Message(mailboxName), // you may want to just hardcode this for your messages, if they're all handled the same
    payload(dataValue) { }
  virtual void* clone() { return new ExampleMessage(mailboxID, payload); }
};

class TestMessaging : public CodeModule {
public:
  TestMessaging(catomID cid) : CodeModule(cid) { }
  void simulationStart();
  
  bool testHandler(ExampleMessage* msg);
  bool testFastHandler(ExampleMessage* msg);
  
protected:
  virtual void endTick();
  
  virtual StateFile::Module* StateFileConstructor( void );
};

#endif
