///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TESTAGGREGATION_HXX
#define __TESTAGGREGATION_HXX

#include "DPRHierarchy.hxx"
#include "GradientHierarchy.hxx"

#include "Network.hxx"

CODE_MODULE_PROTOTYPE( TestAggregation, TestAggregation, "TestAggregation" );
CODE_MODULE_PROTOTYPE( TestAggregation2, TestAggregation, "TestAggregation2" );

#define TESTAGG_SUPER DPRHierarchy

class TestAggregationChildData {
public:
  TestAggregationChildData(double _value=0.0, unsigned long _weight=0) : value(_value), weight(_weight) {};
  double value;
  unsigned long weight;
};

class TestAggregationMsg : public Message {
public:
  TestAggregationMsg(MailboxID _box, catomID _from, double _value, unsigned long _weight) :
    Message(_box),
    from(_from),
    value(_value),
    weight(_weight) {};
  
  catomID from;
  double value;
  unsigned long weight;

  virtual void* clone() { return new TestAggregationMsg(mailboxID, from, value, weight); }
};

class TestAggregation : public TESTAGG_SUPER {
public:
  TestAggregation(catomID _hostCatom, string _hierarchyName);
  virtual ~TestAggregation();
  virtual void simulationStart();
  bool aggMessageHandler(Message* _msg);
  
protected:
  double myAggregateValue;
  long lastAggregateReceived;
  
  MailboxID testAggregationBox;
  
  virtual void endTick();
  virtual void* newChildDataObject();
  
  void sendAggToParent();
};

#endif
