///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>

#include "Sculpture.hxx"
#include "CatomSim.hxx"

CODE_MODULE_DECLARATION( Sculpture, Sculpture );

#include "CatomWorld.hxx"

using namespace std;


void Sculpture::newTick() {
  Catom* hostCatom2 = &(worldPtr->catomHash[hostCatom]->C);
  CatomSim* catomSim = worldPtr->catomHash[hostCatom];

  int down = hostCatom2->getNeighbor(6);
  int negx = hostCatom2->getNeighbor(5);
  int posx = hostCatom2->getNeighbor(2);
  int negy = hostCatom2->getNeighbor(4);
  int posy = hostCatom2->getNeighbor(3);
  int up = hostCatom2->getNeighbor(1);

  Point3D loc = hostCatom2->getLocation();
  
  // distribute the recipe
  if( !up || !down ||
      (!negx && !negy) ||
      (!posx && !posy) ||
      (!posx && !negy) ||
      (!negx && !posy) ||

      (((loc.getY() - loc.getX()) <= 1) &&
       ((loc.getY() - loc.getX()) >= -1)) ||

      (loc.getY() == 1 && 
       loc.getZ() <= 15 && 
       loc.getZ() >= 5) ||

      (loc.getX() == 1 && 
       loc.getZ() <= 21 &&
       loc.getZ() >= 13 )

      ) {
    
    catomSim->red = 0;
    catomSim->green = 125;
    catomSim->blue = 0;
    hostCatom2->setBatteryLife(0);
  }

  return;
}
