///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>

#include "RemoteFeatureTest.hxx"

CODE_MODULE_DECLARATION( RemoteFeatureTest, RemoteFeatureTest );

#include "CatomWorld.hxx"
#include "CatomSim.hxx"

using namespace std;


void RemoteFeatureTest::newTick() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 

  int numNeighbors = 0;

  for(unsigned int i = 1; i <= NUM_FEATURES; i++) {
    // cout << "Catom #" << hostCatom->getID() << ": testing feature #" << i << endl;
    Feature* temp = worldPtr->catomHash[hostCatom]->C.getFeatureMap()[i].getNthRemoteFeature(0);
    
    if (temp == NULL) { 
      // cout << "There is no catom in contact with this feature.\n" << endl;
    }
    else {
      numNeighbors++;
      // cout << "FID found: " << temp->getFID() << endl << endl;
    }
  }
  
  cout << "Catom #" << hostCatom << " is in contact with " 
       << numNeighbors << " other Catoms" << endl;
}
