#ifndef __LEADERELECTION_H
#define __LEADERELECTION_H

class Catom;
class Message;

#include "CodeModule.hxx"
#include "Network.hxx"
#include "CatomWorld.hxx"

CODE_MODULE_PROTOTYPE( LeaderElection, LeaderElection );
using namespace std;

extern CatomWorld *worldPtr;
extern MailboxID leaderElectionMessagingBox;

class LeaderElectionMessage : public Message {
public:
  int hopsLeft;
	catomID leaderID;
  LeaderElectionMessage(MailboxID mailboxName, int h,catomID l) : Message(mailboxName), hopsLeft(h), leaderID(l) { }
  virtual void* clone() { return new LeaderElectionMessage(mailboxID, hopsLeft, leaderID); }
};

class LeaderElection : public CodeModule {
public:
	bool isLeader;
	LeaderElection(catomID _hostCatom);
	void simulationStart();
	virtual void newTick();	
	virtual void endTick();
	bool leaderMsgHandler(LeaderElectionMessage* msg);
};

#endif
