///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __HIERARCHY_H
#define __HIERARCHY_H

class Catom;
class Message;

#include <map>
#include <set>
#include <string>

#include "CodeModule.hxx"
#include "Network.hxx"
#include "Debugging/Debugging.hxx"

class Hierarchy : public CodeModule {
  friend class LandmarkMsg;
  friend class LandmarkBeacon;
  
public:
  Hierarchy(catomID _hostCatom, string _hierarchyName);
  virtual ~Hierarchy();
  catomID getParent();
  string getHierarchyName();
  
protected:
  // Hierarchy subclasses should make sure to call Hierarchy:: version for CodeModule virtual methods like these
  virtual void simulationStart();
  virtual void simulationEnd();
  virtual void endTick();
  
  virtual void dumpStats();
  
  // Allocate an object to store information about a child; stored in the childData map below
  virtual void* newChildDataObject();
  
  // Information about children; key list maintained by hierarchy, contents maintained by subclasses
  map<catomID, void*> childData;
  
  virtual bool sendMsgToParent(Message* msg) = 0;
  
  int getLevel();
  
  StateFile::Module* StateFileConstructor( void );

  string hierarchyName;

  IVAR(catomID, parent);
  IVAR(int,level);
};

#endif
