///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <limits.h>

#include "Hierarchy.hxx"

#include "Catom.hxx"
#include "CatomSim.hxx"
#include "CatomWorld.hxx"
#include "Network.hxx"

#define HIERARCHY_DEBUG (true)


Hierarchy::Hierarchy(catomID _hostCatom, string _hierarchyName) : 
  CodeModule(_hostCatom), 
  hierarchyName(_hierarchyName),
  parent(0),
  level(0) { }

Hierarchy::~Hierarchy() {
  // Clean out the childData
  map<catomID, void*>::iterator i;
  for(i = childData.begin(); i != childData.end(); i++) {
    delete (*i).second;
  }
}

catomID Hierarchy::getParent() {
  return parent;
}

string Hierarchy::getHierarchyName() {
  return hierarchyName;
}

int Hierarchy::getLevel() {
	return level;
}

void Hierarchy::simulationStart() {
  worldPtr->catomHash[hostCatom]->C.getNeighbors();
}

void Hierarchy::simulationEnd() {
  dumpStats();
}

void Hierarchy::dumpStats() {
  worldPtr->oStart();
  cerr << worldPtr->current_time << " Hierarchy(" << hierarchyName << ") "  << hostCatom << ":"
       << " level " << level
       << " parent " << parent 
       << " fanout " << childData.size()
       << endl << flush;
  worldPtr->oEnd();
}

void Hierarchy::endTick() {

}

void* Hierarchy::newChildDataObject() {
  return NULL;
}

// API/Utilities

StateFile::Module* Hierarchy::StateFileConstructor() {
  return NULL;
}
