///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <limits.h>

#include "Hierarchy.hxx"

#include "Catom.hxx"
#include "CatomSim.hxx"
#include "CatomWorld.hxx"
#include "Network.hxx"

#define HIERARCHY_DEBUG (true)


Hierarchy::Hierarchy(catomID _hostCatom, string _hierarchyName) : 
  CodeModule(_hostCatom), 
  hierarchyName(_hierarchyName),
  parent(0),
  level(0) { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__);  }

Hierarchy::~Hierarchy() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  // Clean out the childData
  map<catomID, void*>::iterator i;
  for(i = childData.begin(); i != childData.end(); i++) {
    delete (*i).second;
  }
}

catomID Hierarchy::getParent() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  return parent;
}

string Hierarchy::getHierarchyName() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  return hierarchyName;
}

int Hierarchy::getLevel() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
	return level;
}

void Hierarchy::simulationStart() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  worldPtr->catomHash[hostCatom]->C.getNeighbors();
}

void Hierarchy::simulationEnd() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  dumpStats();
}

void Hierarchy::dumpStats() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  worldPtr->oStart();
  cerr << worldPtr->current_time << " Hierarchy(" << hierarchyName << ") "  << hostCatom << ":"
       << " level " << level
       << " parent " << parent 
       << " fanout " << childData.size()
       << endl << flush;
  worldPtr->oEnd();
}

void Hierarchy::endTick() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 

}

void* Hierarchy::newChildDataObject() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  return NULL;
}

// API/Utilities

StateFile::Module* Hierarchy::StateFileConstructor() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  return NULL;
}
