///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __GRADIENTHIERARCHY_H
#define __GRADIENTHIERARCHY_H

#include "Hierarchy.hxx"

class GradientHierarchy;

class GradientMsg : public Message {
public:
  GradientMsg(GradientHierarchy* _hierarchy);
  GradientMsg(MailboxID _mailboxID);
  virtual void* clone() { return new GradientMsg(mailboxID); }
};

class GradientHierarchy : public Hierarchy {
public:
  GradientHierarchy(catomID _hostCatom, string _hierarchyName);
  ~GradientHierarchy();

  void emitGradient();
  MailboxID gradientBox;

protected:
  virtual void simulationStart();

  virtual bool sendMsgToParent(Message* msg);

private:
  featureID upstreamFeature;
  bool isRoot;

  bool gradientHandler(Message* _msg);
};

#endif
