///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "GradientHierarchy.hxx"

#include "CatomSim.hxx"
#include "CatomWorld.hxx"

using namespace std;

GradientMsg::GradientMsg(GradientHierarchy* _hierarchy) :
  Message(_hierarchy->gradientBox) { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__);  }

GradientMsg::GradientMsg(MailboxID _mailboxID) :
  Message(_mailboxID) { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__);  }

GradientHierarchy::GradientHierarchy(catomID _hostCatom, string _hierarchyName) :
  Hierarchy(_hostCatom, _hierarchyName),
  gradientBox("_gradient_" + _hierarchyName),
  upstreamFeature(0),
  isRoot(false) { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__);  }

GradientHierarchy::~GradientHierarchy() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__);  }

void GradientHierarchy::simulationStart() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  Hierarchy::simulationStart();

  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(gradientBox,
								   this,
								   (msgHandlerPtr)&GradientHierarchy::gradientHandler);
}

bool GradientHierarchy::gradientHandler(Message* _msg) { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  if(!isRoot && (upstreamFeature == 0)) {
    upstreamFeature = _msg->arrivalContact;

    // Propagate the gradient
    for(unsigned int i=1; i<=NUM_FEATURES; i++) {
      Feature* contact = &((worldPtr->catomHash[hostCatom]->C.getFeatureMap())[i]);
      contact->getNetworkAdapter()->sendMessage(new GradientMsg(this));
    }
  }

  return false;
}

void GradientHierarchy::emitGradient() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  isRoot = true;
  for(unsigned int i=1; i<=NUM_FEATURES; i++) {
    Feature* contact = &((worldPtr->catomHash[hostCatom]->C.getFeatureMap())[i]);
    contact->getNetworkAdapter()->sendMessage(new GradientMsg(this));
  }
}

bool GradientHierarchy::sendMsgToParent(Message* msg) { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  if(isRoot) {
    // Root doesn't need to send anything to the parent
    delete msg;
    return false;
  } else if (upstreamFeature == 0) {
    delete msg;
    return false;
  } else {
    Feature* contact = &((worldPtr->catomHash[hostCatom]->C.getFeatureMap())[upstreamFeature]);
    return contact->getNetworkAdapter()->sendMessage(msg);
  }
}
