/***************************************************************************
*   Copyright (C) 2006 by Intel and Carnegie Mellon                       *
*   Contacts: bdr@cs.cmu.edu                                              *
***************************************************************************/

#ifndef __ELLIPSIS_HXX
#define __ELLIPSIS_HXX

#include "DPRHierarchy.hxx"

CODE_MODULE_PROTOTYPE( Ellipsis, Ellipsis, "Ellipsis" );
CODE_MODULE_PROTOTYPE( Ellipsis2, Ellipsis, "Ellipsis2" );

class EllipsisChildData {
public:
  EllipsisChildData(unsigned long _n=0,
		    double _sx=0.0, double _sy=0.0, double _sz=0.0,
		    double _sxx=0.0, double _sxy=0.0, double _sxz=0.0,
		    double _syy=0.0, double _syz=0.0,
		    double _szz=0.0) :
    n(_n),
    sx(_sx), sy(_sy), sz(_sz),
    sxx(_sxx), sxy(_sxy), sxz(_sxz),
    syy(_syy), syz(_syz),
    szz(_szz) {};
  void add(EllipsisChildData otherData);
  
  unsigned long n;
  double sx;
  double sy;
  double sz;
  double sxx;
  double sxy;
  double sxz;
  double syy;
  double syz;
  double szz;
  
  string toString();
};

class EllipsisMsg : public Message {
public:
  EllipsisMsg(MailboxID box, catomID _from, EllipsisChildData _data) :
    Message(box),
    from(_from),
    data(_data) {};
  
  catomID from;
  EllipsisChildData data;

  virtual void* clone() { return new EllipsisMsg(mailboxID, from, data); }
};

class Ellipsis : public DPRHierarchy {
public:
  Ellipsis(catomID _hostCatom, string _hchyName);
  virtual void simulationStart();
  virtual void simulationEnd();
  void aggMessageHandler(Message* _msg);
  
protected:
  MailboxID ellipsisBox;

  long lastAggregateReceived;
  
  virtual void endTick();
  virtual void* newChildDataObject();
  
  void sendAggToParent();
  
  void dumpEllipses();
};



#endif
