///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <string>
#include <stdint.h>

#include "signpost.hxx"

using namespace std;

void dprdebug_signpost(string name, string file, uint32_t line, string function);

signpost::signpost(string _file, uint32_t _line, string _function, uint64_t _hostCatom/*=0*/) :
  file(_file),
  line(_line),
  function(_function),
  hostCatom(_hostCatom)
{
#ifndef DISABLE_DEBUGGING
  dprdebug_signpost("enter block", file, line, function);
#endif
}

signpost::~signpost() {
#ifndef DISABLE_DEBUGGING
  dprdebug_signpost("leave block", file, line, function);
#endif
}
