#!/usr/bin/ruby

# Read the old file into a byte array
inputChars = Array.new;
File.open(ARGV[0], File::RDONLY).each_byte {|byte| inputChars.push(byte) }

# Setup some global vars
nestingDepth = 0;
parensWasLastSeen = false;

# Write the new file
File.open(ARGV[1], File::CREAT|File::TRUNC|File::WRONLY) do |outFile|
  while inputChars.length > 0 do
    char = inputChars.shift
    outFile.putc(char);

    if char == ?( || char == ?{ then
      # Open grouper
      outFile << (" signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); ") if char == ?{ && nestingDepth == 0 && parensWasLastSeen;
      nestingDepth += 1;
    elsif char == ?) || char == ?} then
      # Close grouper
      nestingDepth -= 1;
      parensWasLastSeen = char == ?);
    elsif char == ?/ then
      # Possible comment
      if inputChars[0] == ?/
	# One-line comment
	while char != ?\n
	  char = inputChars.shift;
	  outFile.putc(char);
	end
      elsif inputChars[0] == ?*
	# Multi-line comment
	char = inputChars.shift;
	outFile.putc(char); # Pass through the *
	while inputChars[0] != ?* || inputChars[1] != ?/
	  char = inputChars.shift;
	  outFile.putc(char);
	end
	char = inputChars.shift;
	outFile.putc(char); # Pass through the *
	char = inputChars.shift;
	outFile.putc(char); # Pass through the /
      end
    end
  end
end
