#include <iostream>
#include <string.h>

#include "Color.hxx"

#include "CatomSim.hxx"

using namespace std;

CODE_MODULE_DECLARATION( COLOR, ColorModule );

StateFile::Module* ColorModule::StateFileConstructor() {

  myModule_ = StateFile::Module::getInstance( name_ );
  myModule_->setSkip( true );

  // Check to see if this module has already been setup
  if (myModule_->getVersion())
    return myModule_;

  // If not, set up this module for the first time
  myModule_->setVersion( 1 );
  myModule_->setVersionRange( 1 );

  return myModule_;
}

void ColorModule::startSimulation() {
  CatomSim * catomSim = worldPtr->catomHash[hostCatom];
  catomSim->red = catomSim->green = catomSim->blue = 200;
  upColor_ = true;
}

void ColorModule::newTick() {
  
  CatomSim * catomSim = worldPtr->catomHash[hostCatom];

  uint8* color;

  switch (hostCatom % 3) {
  case 0:
    color = &(catomSim->red);
    break;

  case 1:
    color = &(catomSim->green);
    break;

  case 2:
    color = &(catomSim->blue);
    break;
  }

  if (upColor_) {
    (*color) += 5;
    upColor_ = (*color) < 250;
  } else {
    (*color) -= 5;
    upColor_ = (*color) < 10;
  }
}

